/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2015-04-25 15:18:42 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=308 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20150425_arcengineering", "553bb0360b5df9950150425151814", "20", "2015-04-25 15:18:42", "admin", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:1;s:4:\"Name\";s:23:\"20150425_arcengineering\";s:4:\"Hash\";s:29:\"553bb0360b5df9950150425151814\";s:8:\"NameHash\";s:53:\"20150425_arcengineering_553bb0360b5df9950150425151814\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:59:\"/home/sightseer/public_html/arcengineering/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://sightseer.ca/arcengineering/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150425_arcengineering_553bb0360b5df9950150425151814_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150425_arcengineering_553bb0360b5df9950150425151814_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:42:\"/home/sightseer/public_html/arcengineering\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150425_arcengineering\";s:4:\"Hash\";s:29:\"553bb0360b5df9950150425151814\";s:8:\"NameHash\";s:53:\"20150425_arcengineering_553bb0360b5df9950150425151814\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:59:\"/home/sightseer/public_html/arcengineering/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://sightseer.ca/arcengineering/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:67:\"20150425_arcengineering_553bb0360b5df9950150425151814_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:66:\"20150425_arcengineering_553bb0360b5df9950150425151814_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("1", "0", "Enfold - most beautiful theme ever", "", "{\"properties\":{\"title\":\"Enfold - most beautiful theme ever\",\"width\":\"100%\",\"height\":\"470\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"1140\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"hoverbottomnav\":\"on\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"80\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"all\",\"2d_transitions\":\"11,13,23\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_1.png\",\"thumbnail\":\"\",\"slidedelay\":\"7000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Imac\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_iMac.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1400\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1400\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"68px\",\"left\":\"509px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"macbook\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_MacBook_Pro.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeOutQuint\",\"delayin\":\"400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1200\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"6\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"191px\",\"left\":\"791px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"ipad\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Mini_iPad_White.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"800\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"9\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"237px\",\"left\":\"439px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iphone\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_iPhone_5.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"400\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"12\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"316px\",\"left\":\"581px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_2.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"900\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"143px\",\"left\":\"114px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Our_Most_Beautiful_Theme_Ever.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"900\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"900\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"200\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"238px\",\"left\":\"113px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_Layer_5.png\",\"thumbnail\":\"\",\"slidedelay\":\"8000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"browser bg copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_sbrowser_bg.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"154px\",\"left\":\"749px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"browser bg\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_sbrowser_bg.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"98px\",\"left\":\"608px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"browser front\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_browser.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"300\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"26px\",\"left\":\"467px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"fullwidth\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_fullwidth_slider.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"477px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"1-3\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_1_3.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1250\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"194px\",\"left\":\"481px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"1-3 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_1_3.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"193px\",\"left\":\"675px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"1-3 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_1_3.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1750\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"192px\",\"left\":\"872px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iconbox\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_iconbox.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"214px\",\"left\":\"488px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iconbox copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_iconbox.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2250\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"214px\",\"left\":\"683px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iconbox copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_iconbox.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"214px\",\"left\":\"879px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"1-2\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_1_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2750\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"294px\",\"left\":\"483px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"1-2 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_1_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"294px\",\"left\":\"775px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_textblock.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3250\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"315px\",\"left\":\"491px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Gallery\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_sgallery.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"382px\",\"left\":\"492px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Gallery copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_sgallery.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3750\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"412px\",\"left\":\"492px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Gallery copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_sgallery.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"4000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"316px\",\"left\":\"784px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide2_textblock.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"4250\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"346px\",\"left\":\"783px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"flexible\",\"type\":\"h2\",\"image\":\"\",\"html\":\"Super Flexible Layout Builder\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"135px\",\"left\":\"90px\",\"style\":\"box-shadow: 0px 4px 10px -5px black; text-shadow: none; font-weight: normal; opacity: .65; width:320px; text-align:right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text\",\"type\":\"span\",\"image\":\"\",\"html\":\"Tons of Elements\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"188px\",\"left\":\"243px\",\"style\":\"box-shadow: 0px 4px 10px -5px black; text-shadow: none; font-weight: normal; opacity: .65; width:200px; text-align:right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text\",\"type\":\"span\",\"image\":\"\",\"html\":\"Real Drag and Drop\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"228px\",\"left\":\"243px\",\"style\":\"box-shadow: 0px 4px 10px -5px black; text-shadow: none; font-weight: normal; opacity: .65; width:200px; text-align:right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text copy\",\"type\":\"span\",\"image\":\"\",\"html\":\"Fullscreen Option\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"269px\",\"left\":\"243px\",\"style\":\"box-shadow: 0px 4px 10px -5px black; text-shadow: none; font-weight: normal; opacity: .65; width:200px; text-align:right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Text\",\"type\":\"span\",\"image\":\"\",\"html\":\"Undo\\/Redo functionallity\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1900\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"309px\",\"left\":\"243px\",\"style\":\"box-shadow: 0px 4px 10px -5px black; text-shadow: none; font-weight: normal; opacity: .65; width:200px; text-align:right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1416882428", "1416882428", "0", "0");
INSERT INTO `wp_layerslider` VALUES("2", "0", "Why Enfold - Small Header", "", "{\"properties\":{\"title\":\"Why Enfold - Small Header\",\"width\":\"100%\",\"height\":\"150\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1140\",\"sublayercontainer\":\"1140\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"1\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"#aac98e\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_Layer_1.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1200\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"150\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-18px\",\"left\":\"800px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1300\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"842px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l17.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"350\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-279px\",\"left\":\"951px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l13.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"450\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-156px\",\"left\":\"51px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1 copy copy\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide3_l16.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-22px\",\"left\":\"-107px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"h2\",\"image\":\"\",\"html\":\"Why you should choose\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"650\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"68px\",\"left\":\"214px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"img\",\"image\":\"http:\\/\\/sightseer.ca\\/arcengineering\\/wp-content\\/themes\\/enfold\\/config-layerslider\\/LayerSlider\\/avia-samples\\/slide1_Layer_2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"684px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1416882428", "1416882428", "0", "0");
INSERT INTO `wp_layerslider` VALUES("3", "2", "engineering", "", "{\"properties\":{\"title\":\"engineering\"},\"layers\":[[]]}", "1420818032", "1420818032", "0", "1");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://sightseer.ca/arcengineering", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://sightseer.ca/arcengineering", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Arc Engineering", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "kbanse@bansecreative.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "gzipcompression", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:1:{i:0;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "advanced_edit", "0", "yes");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("41", "template", "enfold", "yes");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "enfold", "yes");
INSERT INTO `wp_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("45", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("49", "db_version", "31532", "yes");
INSERT INTO `wp_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("54", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_w", "80", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_size_h", "80", "yes");
INSERT INTO `wp_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_w", "1030", "yes");
INSERT INTO `wp_options` VALUES("66", "large_size_h", "1030", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("74", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("81", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("82", "uninstall_plugins", "a:1:{s:113:\"home/sightseer/public_html/arcengineering/wp-content/themes/enfold/config-layerslider/LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";}", "no");
INSERT INTO `wp_options` VALUES("83", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("84", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "page_on_front", "2", "yes");
INSERT INTO `wp_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "initial_db_version", "29630", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("90", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("91", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("92", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("93", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;s:9:\"sidebar-7\";N;s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("96", "cron", "a:5:{i:1429989180;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1430011523;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1430011554;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1430011575;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("104", "_transient_random_seed", "d1c7bb6480609d55f7dace77bd9b33ff", "yes");
INSERT INTO `wp_options` VALUES("135", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("146", "theme_mods_twentyfourteen", "a:2:{s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:9:\"secondary\";i:0;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1416882427;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("147", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("154", "current_theme", "Enfold", "yes");
INSERT INTO `wp_options` VALUES("155", "theme_mods_enfold", "a:1:{i:0;b:0;}", "yes");
INSERT INTO `wp_options` VALUES("156", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("157", "ls-plugin-version", "5.3.2", "yes");
INSERT INTO `wp_options` VALUES("158", "ls-db-version", "5.0.0", "yes");
INSERT INTO `wp_options` VALUES("159", "ls-installed", "1", "yes");
INSERT INTO `wp_options` VALUES("160", "ls-google-fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("161", "ls-date-installed", "1416882428", "yes");
INSERT INTO `wp_options` VALUES("163", "enfold_layerslider_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("164", "enfold_initial_version", "3.0.4", "yes");
INSERT INTO `wp_options` VALUES("165", "enfold_fixed_random", "7", "yes");
INSERT INTO `wp_options` VALUES("166", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:450;s:6:\"height\";i:450;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("167", "shop_single_image_size", "a:3:{s:5:\"width\";i:450;s:6:\"height\";i:999;s:4:\"crop\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("168", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:120;s:6:\"height\";i:120;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("169", "avia_woocommerce_column_count", "3", "yes");
INSERT INTO `wp_options` VALUES("170", "avia_woocommerce_product_count", "15", "yes");
INSERT INTO `wp_options` VALUES("171", "woocommerce_single_image_crop", "no", "yes");
INSERT INTO `wp_options` VALUES("172", "avia_permalink_settings", "a:2:{s:24:\"portfolio_permalink_base\";s:14:\"portfolio-item\";s:31:\"portfolio_entries_taxonomy_base\";s:17:\"portfolio_entries\";}", "yes");
INSERT INTO `wp_options` VALUES("174", "Enfold_version", "3.0.4", "yes");
INSERT INTO `wp_options` VALUES("175", "avia_stylesheet_dir_writableenfold", "true", "yes");
INSERT INTO `wp_options` VALUES("176", "avia_stylesheet_existsenfold", "true", "yes");
INSERT INTO `wp_options` VALUES("177", "avia_stylesheet_dynamic_versionenfold", "55399f928bb96", "yes");
INSERT INTO `wp_options` VALUES("178", "enfold_woo_settings_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("179", "avia_rewrite_flush", "1", "yes");
INSERT INTO `wp_options` VALUES("180", "avia_options_enfold", "a:1:{s:4:\"avia\";a:135:{s:9:\"frontpage\";s:1:\"2\";s:9:\"undefined\";s:17:\"Use Image as logo\";s:8:\"blogpage\";s:2:\"46\";s:4:\"logo\";s:75:\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/04/ARC_Logo1.png\";s:7:\"favicon\";s:0:\"\";s:15:\"websave_windows\";s:0:\"\";s:6:\"markup\";s:0:\"\";s:15:\"lightbox_active\";s:15:\"lightbox_active\";s:9:\"analytics\";s:731:\"&lt;script src=&quot;http://www.google-analytics.com/ga.js&quot; async=&quot;&quot; type=&quot;text/javascript&quot;&gt;&lt;/script&gt;&lt;script type=&quot;text/javascript&quot;&gt;\n\n  var _gaq = _gaq || [];\n  _gaq.push([&#039;_setAccount&#039;, &#039;UA-21874685-1&#039;]);\n  _gaq.push([&#039;_trackPageview&#039;]);\n\n  (function() {\n    var ga = document.createElement(&#039;script&#039;); ga.type = &#039;text/javascript&#039;; ga.async = true;\n    ga.src = (&#039;https:&#039; == document.location.protocol ? &#039;https://ssl&#039; : &#039;http://www&#039;) + &#039;.google-analytics.com/ga.js&#039;;\n    var s = document.getElementsByTagName(&#039;script&#039;)[0]; s.parentNode.insertBefore(ga, s);\n  })();\n\n&lt;/script&gt;\";s:16:\"color-body_style\";s:9:\"stretched\";s:15:\"header_position\";s:10:\"header_top\";s:20:\"layout_align_content\";s:20:\"content_align_center\";s:18:\"sidebarmenu_sticky\";s:18:\"conditional_sticky\";s:19:\"sidebarmenu_widgets\";s:0:\"\";s:18:\"sidebarmenu_social\";s:8:\"disabled\";s:17:\"responsive_active\";s:17:\"responsive_active\";s:15:\"responsive_size\";s:6:\"1310px\";s:13:\"content_width\";s:2:\"73\";s:14:\"combined_width\";s:3:\"100\";s:12:\"color_scheme\";s:4:\"Blue\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#2e2c28\";s:31:\"colorset-header_color-secondary\";s:7:\"#d1881b\";s:27:\"colorset-header_color-color\";s:7:\"#292724\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:8:\"top left\";s:28:\"colorset-header_color-repeat\";s:9:\"no-repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#d1881b\";s:29:\"colorset-main_color-secondary\";s:7:\"#353830\";s:25:\"colorset-main_color-color\";s:7:\"#666666\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:8:\"top left\";s:26:\"colorset-main_color-repeat\";s:9:\"no-repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#ffffff\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#f8f8f8\";s:32:\"colorset-alternate_color-primary\";s:7:\"#719430\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#8bba34\";s:30:\"colorset-alternate_color-color\";s:7:\"#666666\";s:31:\"colorset-alternate_color-border\";s:7:\"#e1e1e1\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:8:\"top left\";s:31:\"colorset-alternate_color-repeat\";s:9:\"no-repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-footer_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-footer_color-primary\";s:7:\"#719430\";s:31:\"colorset-footer_color-secondary\";s:7:\"#8bba34\";s:27:\"colorset-footer_color-color\";s:7:\"#666666\";s:28:\"colorset-footer_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-footer_color-img\";s:0:\"\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:8:\"top left\";s:28:\"colorset-footer_color-repeat\";s:9:\"no-repeat\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-socket_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-socket_color-primary\";s:7:\"#719430\";s:31:\"colorset-socket_color-secondary\";s:7:\"#8bba34\";s:27:\"colorset-socket_color-color\";s:7:\"#666666\";s:28:\"colorset-socket_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:8:\"top left\";s:28:\"colorset-socket_color-repeat\";s:9:\"no-repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:16:\"color-body_color\";s:7:\"#eeeeee\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:8:\"top left\";s:17:\"color-body_repeat\";s:9:\"no-repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:14:\"google_webfont\";s:0:\"\";s:12:\"default_font\";s:15:\"Verdana-websave\";s:9:\"quick_css\";s:0:\"\";s:16:\"advanced_styling\";a:1:{i:0;a:7:{s:2:\"id\";s:18:\"main_menu_dropdown\";s:5:\"color\";s:7:\"#d1881b\";s:16:\"background_color\";s:0:\"\";s:12:\"border_color\";s:0:\"\";s:9:\"font_size\";s:0:\"\";s:11:\"line_height\";s:0:\"\";s:12:\"hover_active\";s:8:\"disabled\";}}s:13:\"header_layout\";s:36:\"logo_left main_nav_header menu_right\";s:11:\"header_size\";s:5:\"large\";s:18:\"header_custom_size\";s:3:\"150\";s:16:\"header_title_bar\";s:9:\"title_bar\";s:13:\"header_sticky\";s:13:\"header_sticky\";s:16:\"header_shrinking\";s:16:\"header_shrinking\";s:14:\"header_stretch\";s:8:\"disabled\";s:17:\"header_searchicon\";s:17:\"header_searchicon\";s:13:\"header_social\";s:0:\"\";s:21:\"header_secondary_menu\";s:0:\"\";s:19:\"header_phone_active\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:23:\"header_replacement_logo\";s:0:\"\";s:23:\"header_replacement_menu\";s:0:\"\";s:24:\"header_mobile_activation\";s:18:\"mobile_menu_tablet\";s:22:\"header_mobile_behavior\";s:8:\"disabled\";s:14:\"archive_layout\";s:8:\"fullsize\";s:11:\"blog_layout\";s:8:\"fullsize\";s:13:\"single_layout\";s:8:\"fullsize\";s:11:\"page_layout\";s:8:\"fullsize\";s:19:\"smartphones_sidebar\";s:8:\"disabled\";s:16:\"page_nesting_nav\";s:16:\"page_nesting_nav\";s:22:\"display_widgets_socket\";s:12:\"nofooterarea\";s:14:\"footer_columns\";s:1:\"1\";s:9:\"copyright\";s:35:\"&copy; Copyright - Arc Engineering \";s:13:\"footer_social\";s:8:\"disabled\";s:10:\"blog_style\";s:9:\"blog-grid\";s:17:\"single_post_style\";s:10:\"single-big\";s:27:\"single_post_related_entries\";s:8:\"disabled\";s:16:\"blog-meta-author\";s:8:\"disabled\";s:18:\"blog-meta-comments\";s:8:\"disabled\";s:18:\"blog-meta-category\";s:8:\"disabled\";s:14:\"blog-meta-date\";s:14:\"blog-meta-date\";s:19:\"blog-meta-html-info\";s:8:\"disabled\";s:13:\"blog-meta-tag\";s:8:\"disabled\";s:14:\"share_facebook\";s:14:\"share_facebook\";s:13:\"share_twitter\";s:13:\"share_twitter\";s:15:\"share_pinterest\";s:8:\"disabled\";s:11:\"share_gplus\";s:11:\"share_gplus\";s:12:\"share_reddit\";s:8:\"disabled\";s:14:\"share_linkedin\";s:14:\"share_linkedin\";s:12:\"share_tumblr\";s:8:\"disabled\";s:8:\"share_vk\";s:8:\"disabled\";s:10:\"share_mail\";s:10:\"share_mail\";s:12:\"social_icons\";a:2:{i:0;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:25:\"http://twitter.com/kriesi\";}i:1;a:2:{s:11:\"social_icon\";s:8:\"dribbble\";s:16:\"social_icon_link\";s:26:\"http://dribbble.com/kriesi\";}}s:17:\"avia-nonce-import\";s:10:\"421ab73cd7\";s:18:\"config_file_upload\";s:0:\"\";s:15:\"iconfont_upload\";s:0:\"\";s:16:\"updates_username\";s:0:\"\";s:15:\"updates_api_key\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("186", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("443", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("445", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("645", "portfolio_entries_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("735", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"kbanse@bansecreative.com\";s:7:\"version\";s:5:\"4.1.3\";s:9:\"timestamp\";i:1429839173;}", "yes");
INSERT INTO `wp_options` VALUES("848", "_site_transient_timeout_browser_70e60c8d51f37bd65a1aac7c033c1211", "1430443990", "yes");
INSERT INTO `wp_options` VALUES("849", "_site_transient_browser_70e60c8d51f37bd65a1aac7c033c1211", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"37.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("871", "_site_transient_timeout_browser_d7bfebab08f0e875ec525b36fe2598e7", "1430484504", "yes");
INSERT INTO `wp_options` VALUES("872", "_site_transient_browser_d7bfebab08f0e875ec525b36fe2598e7", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"42.0.2311.90\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("895", "_site_transient_timeout_theme_roots", "1429975684", "yes");
INSERT INTO `wp_options` VALUES("896", "_site_transient_theme_roots", "a:5:{s:6:\"enfold\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_options` VALUES("897", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1429975081;s:7:\"checked\";a:5:{s:6:\"enfold\";s:5:\"3.0.4\";s:13:\"twentyfifteen\";s:3:\"1.0\";s:14:\"twentyfourteen\";s:3:\"1.3\";s:14:\"twentythirteen\";s:3:\"1.4\";s:12:\"twentytwelve\";s:3:\"1.6\";}s:8:\"response\";a:4:{s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.1.1.zip\";}s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.1.4.zip\";}s:14:\"twentythirteen\";a:4:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentythirteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentythirteen.1.5.zip\";}s:12:\"twentytwelve\";a:4:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwelve/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwelve.1.7.zip\";}}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("899", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1430018209", "no");
INSERT INTO `wp_options` VALUES("900", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1430018209", "no");
INSERT INTO `wp_options` VALUES("901", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1429975009", "no");
INSERT INTO `wp_options` VALUES("902", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1430018210", "no");
INSERT INTO `wp_options` VALUES("903", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1430018210", "no");
INSERT INTO `wp_options` VALUES("904", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1429975010", "no");
INSERT INTO `wp_options` VALUES("905", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1430018210", "no");
INSERT INTO `wp_options` VALUES("906", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Apr 2015 15:07:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast&#039;s WordPress SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Broken Link Checker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/broken-link-checker/#post-2441\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Oct 2007 21:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2441@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"This plugin will check your posts, comments and other content for broken links and missing images, and notify you if any are found.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Janis Elsts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WP Smush\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-smushit/#post-7936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Dec 2008 00:00:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"7936@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"Reduce image file sizes, improve performance and boost your SEO using the free WPMU DEV WordPress Smush API.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alex Dunae\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38058@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Displays Google Analytics reports and real-time statistics in your WordPress Dashboard. Inserts the latest tracking code in every page of your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"WPtouch Mobile Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wptouch/#post-5468\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 May 2008 04:58:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5468@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Make your WordPress website mobile-friendly with just a few clicks.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"BraveNewCode Inc.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"49521@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 12 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"ManageWP Worker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/worker/#post-24528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Feb 2011 13:06:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"24528@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"ManageWP is the ultimate WordPress productivity tool, allowing you to efficiently manage your websites.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vladimir Prelovac\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"MailChimp for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/mailchimp-for-wp/#post-54377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Jun 2013 17:32:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"54377@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The best MailChimp plugin to get more email subscribers. Easily add MailChimp sign-up forms and sign-up checkboxes to your WordPress site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Danny van Kooten\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/buddypress/#post-10314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Apr 2009 17:48:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"10314@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"BuddyPress helps you run any kind of social network on your WordPress, with member profiles, activity streams, user groups, messaging, and more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andy Peatling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"P3 (Plugin Performance Profiler)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/p3-profiler/#post-32894\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Dec 2011 23:11:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"32894@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"See which plugins are slowing down your site.  This plugin creates a performance report for your site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"GoDaddy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"28395@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"EWWW Image Optimizer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/ewww-image-optimizer/#post-38780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Jun 2012 19:30:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38780@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Reduce file sizes for images in WordPress including NextGEN, GRAND FlAGallery and more using lossless/lossy methods and image format conversion.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"nosilver4u\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"bbPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/bbpress/#post-14709\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 13 Dec 2009 00:05:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"14709@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"bbPress is forum software, made the WordPress way.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 25 Apr 2015 15:16:50 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Thu, 20 Jan 2011 02:21:38 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20141125012115\";}", "no");
INSERT INTO `wp_options` VALUES("907", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1430018210", "no");
INSERT INTO `wp_options` VALUES("908", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1429975010", "no");
INSERT INTO `wp_options` VALUES("909", "_transient_timeout_plugin_slugs", "1430061485", "no");
INSERT INTO `wp_options` VALUES("910", "_transient_plugin_slugs", "a:3:{i:0;s:19:\"akismet/akismet.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:9:\"hello.php\";}", "no");
INSERT INTO `wp_options` VALUES("911", "_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51", "1430018210", "no");
INSERT INTO `wp_options` VALUES("912", "_transient_dash_4077549d03da2e451c8b5f002294ff51", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2015/04/powell/\'>WordPress 4.2 “Powell”</a> <span class=\"rss-date\">April 23, 2015</span><div class=\"rssSummary\">Version 4.2 of WordPress, named “Powell” in honor of jazz pianist Bud Powell, is available for download or update in your WordPress dashboard. New features in 4.2 help you communicate and share, globally. An easier way to share content Clip it, edit it, publish it. Get familiar with the new and improved Press This. From [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://ma.tt/2015/04/atlantic-earth-day-pictures/\'>Matt: Atlantic Earth Day Pictures</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/automattics-dave-martin-publishes-his-5-step-remote-hiring-process\'>WPTavern: Automattic’s Dave Martin Publishes His 5 Step Remote Hiring Process</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/story-am-relaunches-now-100-free\'>WPTavern: Story.am Relaunches, Now 100% Free</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/mailchimp-for-wp/\' class=\'dashboard-news-plugin-link\'>MailChimp for WordPress</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=mailchimp-for-wp&amp;_wpnonce=019bbc469d&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'MailChimp for WordPress\'>Install</a>)</span></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("914", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.2.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.2-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.2\";s:7:\"version\";s:3:\"4.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1429975024;s:15:\"version_checked\";s:3:\"4.2\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("915", "rewrite_rules", "a:86:{s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)(/[0-9]+)?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:53:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("916", "can_compress_scripts", "1", "yes");
INSERT INTO `wp_options` VALUES("918", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1429985867", "yes");
INSERT INTO `wp_options` VALUES("919", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:40:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5134\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3220\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3147\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2669\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2462\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"1975\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"1854\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1809\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1756\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1743\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1701\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1696\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1589\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1381\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1338\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1267\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1196\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1131\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1129\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:3:\"990\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:3:\"954\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:3:\"918\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"873\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:3:\"866\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"852\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"837\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"796\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"772\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"744\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"727\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"717\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"706\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"680\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"678\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"669\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"659\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"638\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"629\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"627\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"624\";}}", "yes");
INSERT INTO `wp_options` VALUES("920", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1429975083;s:7:\"checked\";a:3:{s:19:\"akismet/akismet.php\";s:5:\"3.1.1\";s:25:\"duplicator/duplicator.php\";s:6:\"0.5.16\";s:9:\"hello.php\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.1.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.16\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.16.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}}}", "yes");
INSERT INTO `wp_options` VALUES("921", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"0.5.16\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("922", "duplicator_version_plugin", "0.5.16", "yes");
INSERT INTO `wp_options` VALUES("923", "duplicator_ui_view_state", "a:3:{s:14:\"dup-wpnotice01\";b:1;s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("924", "duplicator_package_active", "O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150425_arcengineering\";s:4:\"Hash\";s:29:\"553bb0360b5df9950150425151814\";s:8:\"NameHash\";s:53:\"20150425_arcengineering_553bb0360b5df9950150425151814\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:59:\"/home/sightseer/public_html/arcengineering/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://sightseer.ca/arcengineering/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150425_arcengineering_553bb0360b5df9950150425151814_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:42:\"/home/sightseer/public_html/arcengineering\";s:4:\"Size\";i:0;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150425_arcengineering\";s:4:\"Hash\";s:29:\"553bb0360b5df9950150425151814\";s:8:\"NameHash\";s:53:\"20150425_arcengineering_553bb0360b5df9950150425151814\";s:7:\"Version\";s:6:\"0.5.16\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:59:\"/home/sightseer/public_html/arcengineering/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://sightseer.ca/arcengineering/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:30;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:30;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";r:45;s:8:\"Database\";r:57;}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "2", "_edit_lock", "1429900133:3");
INSERT INTO `wp_postmeta` VALUES("3", "2", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("4", "5", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_edit_lock", "1429880335:3");
INSERT INTO `wp_postmeta` VALUES("6", "5", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("7", "8", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("8", "8", "_edit_lock", "1424195722:2");
INSERT INTO `wp_postmeta` VALUES("9", "8", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("10", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("11", "10", "_edit_lock", "1429900222:3");
INSERT INTO `wp_postmeta` VALUES("12", "10", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("13", "12", "_wp_attached_file", "2014/11/ARC-Brochure-Commercial.pdf");
INSERT INTO `wp_postmeta` VALUES("14", "13", "_wp_attached_file", "2014/11/ARC-Brochure-Educational.pdf");
INSERT INTO `wp_postmeta` VALUES("15", "14", "_wp_attached_file", "2014/11/ARC-Brochure-HealthCare.pdf");
INSERT INTO `wp_postmeta` VALUES("16", "15", "_wp_attached_file", "2014/11/ARC-Brochure-Industrial.pdf");
INSERT INTO `wp_postmeta` VALUES("17", "16", "_wp_attached_file", "2014/11/ARC-Brochure-LEED-Energy.pdf");
INSERT INTO `wp_postmeta` VALUES("18", "17", "_wp_attached_file", "2014/11/Designer.pdf");
INSERT INTO `wp_postmeta` VALUES("19", "18", "_wp_attached_file", "2014/11/Technologist.pdf");
INSERT INTO `wp_postmeta` VALUES("20", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("21", "21", "_edit_lock", "1429901558:3");
INSERT INTO `wp_postmeta` VALUES("22", "21", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("23", "24", "_edit_last", "2");
INSERT INTO `wp_postmeta` VALUES("24", "24", "_edit_lock", "1429900277:3");
INSERT INTO `wp_postmeta` VALUES("25", "24", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("26", "26", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("27", "26", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("28", "26", "_menu_item_object_id", "24");
INSERT INTO `wp_postmeta` VALUES("29", "26", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("30", "26", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("31", "26", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("32", "26", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("33", "26", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("35", "27", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("36", "27", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("37", "27", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("38", "27", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("39", "27", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("40", "27", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("41", "27", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("42", "27", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("44", "28", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("45", "28", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("46", "28", "_menu_item_object_id", "10");
INSERT INTO `wp_postmeta` VALUES("47", "28", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("48", "28", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("49", "28", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("50", "28", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("51", "28", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("53", "29", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("54", "29", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("55", "29", "_menu_item_object_id", "8");
INSERT INTO `wp_postmeta` VALUES("56", "29", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("57", "29", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("58", "29", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("59", "29", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("60", "29", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("62", "30", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("63", "30", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("64", "30", "_menu_item_object_id", "5");
INSERT INTO `wp_postmeta` VALUES("65", "30", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("66", "30", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("67", "30", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("68", "30", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("69", "30", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("71", "31", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("72", "31", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("73", "31", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("74", "31", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("75", "31", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("76", "31", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("77", "31", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("78", "31", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("80", "36", "_wp_attached_file", "2014/11/ARC_Logo-small.png");
INSERT INTO `wp_postmeta` VALUES("81", "36", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:150;s:6:\"height\";i:74;s:4:\"file\";s:26:\"2014/11/ARC_Logo-small.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"ARC_Logo-small-80x74.png\";s:5:\"width\";i:80;s:6:\"height\";i:74;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:24:\"ARC_Logo-small-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"ARC_Logo-small-120x74.png\";s:5:\"width\";i:120;s:6:\"height\";i:74;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("82", "2", "_aviaLayoutBuilder_active", "active");
INSERT INTO `wp_postmeta` VALUES("83", "2", "_aviaLayoutBuilderCleanData", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'166\'][/av_slide_full]\r\n[av_slide_full id=\'167\'][/av_slide_full]\r\n[av_slide_full id=\'168\'][/av_slide_full]\r\n[av_slide_full id=\'162\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("84", "2", "_avia_builder_shortcode_tree", "a:3:{i:0;a:3:{s:3:\"tag\";s:17:\"av_slideshow_full\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:12:\"av_portfolio\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}");
INSERT INTO `wp_postmeta` VALUES("85", "2", "layout", "");
INSERT INTO `wp_postmeta` VALUES("86", "2", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("87", "2", "footer", "");
INSERT INTO `wp_postmeta` VALUES("88", "2", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("89", "2", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("90", "2", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("99", "46", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("100", "46", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("101", "46", "_aviaLayoutBuilder_active", "");
INSERT INTO `wp_postmeta` VALUES("102", "46", "_aviaLayoutBuilderCleanData", "");
INSERT INTO `wp_postmeta` VALUES("103", "46", "layout", "");
INSERT INTO `wp_postmeta` VALUES("104", "46", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("105", "46", "footer", "");
INSERT INTO `wp_postmeta` VALUES("106", "46", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("107", "46", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("108", "46", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("109", "46", "_edit_lock", "1416884331:1");
INSERT INTO `wp_postmeta` VALUES("110", "8", "_aviaLayoutBuilder_active", "active");
INSERT INTO `wp_postmeta` VALUES("111", "8", "_aviaLayoutBuilderCleanData", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'177\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'176\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'175\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'174\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Services</h3>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Partnerships</h3>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("112", "8", "_avia_builder_shortcode_tree", "a:3:{i:0;a:3:{s:3:\"tag\";s:17:\"av_slideshow_full\";s:7:\"content\";a:0:{}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}}s:5:\"index\";i:1;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}}s:5:\"index\";i:3;}}");
INSERT INTO `wp_postmeta` VALUES("113", "8", "layout", "");
INSERT INTO `wp_postmeta` VALUES("114", "8", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("115", "8", "footer", "");
INSERT INTO `wp_postmeta` VALUES("116", "8", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("117", "8", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("118", "8", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("119", "5", "_aviaLayoutBuilder_active", "active");
INSERT INTO `wp_postmeta` VALUES("120", "5", "_aviaLayoutBuilderCleanData", "[av_one_half first]\r\n\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'62\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'140\'][/av_slide]\r\n[av_slide id=\'141\'][/av_slide]\r\n[av_slide id=\'137\'][/av_slide]\r\n[av_slide id=\'134\'][/av_slide]\r\n[/av_slideshow]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\"  wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"150\" height=\"150\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\"  wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"150\" height=\"150\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("121", "5", "_avia_builder_shortcode_tree", "a:4:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_slideshow\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}i:3;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}}s:5:\"index\";i:6;}}");
INSERT INTO `wp_postmeta` VALUES("122", "5", "layout", "");
INSERT INTO `wp_postmeta` VALUES("123", "5", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("124", "5", "footer", "");
INSERT INTO `wp_postmeta` VALUES("125", "5", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("126", "5", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("127", "5", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("128", "21", "_aviaLayoutBuilder_active", "active");
INSERT INTO `wp_postmeta` VALUES("129", "21", "_aviaLayoutBuilderCleanData", "[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Address</h5>\r\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\r\n\r\nPhone: (905) 643-8530 Fax: (905) 643-8510\r\n\r\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<!-- Google Map of location-->\r\n<iframe src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\r\n\r\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Address</h5>\r\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\r\n\r\nPhone: (905) 643-8530 Fax: (905) 643-8510\r\n\r\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\r\n\r\n<!-- Google Map of location-->\r\n<iframe src=\"https://maps.google.com/maps?f=q&source=s_q&hl=en&geocode=&q=1100+South+Service+Road,+Hamilton,+ON,+Canada&aq=1&oq=1100+SOUTH+SER&sll=43.272523,-79.482372&sspn=0.779922,1.783905&t=w&ie=UTF8&hq=&hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&z=14&ll=43.222301,-79.659914&output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\r\n\r\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&source=embed&hl=en&geocode=&q=1100+South+Service+Road,+Hamilton,+ON,+Canada&aq=1&oq=1100+SOUTH+SER&sll=43.272523,-79.482372&sspn=0.779922,1.783905&t=w&ie=UTF8&hq=&hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&z=14&ll=43.222301,-79.659914\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\r\n[/av_textblock]\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("130", "21", "_avia_builder_shortcode_tree", "a:4:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}}s:5:\"index\";i:4;}i:3;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:6;}}");
INSERT INTO `wp_postmeta` VALUES("131", "21", "layout", "");
INSERT INTO `wp_postmeta` VALUES("132", "21", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("133", "21", "footer", "");
INSERT INTO `wp_postmeta` VALUES("134", "21", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("135", "21", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("136", "21", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("137", "10", "_aviaLayoutBuilder_active", "active");
INSERT INTO `wp_postmeta` VALUES("138", "10", "_aviaLayoutBuilderCleanData", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n\r\n<hr />\r\n\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n\r\n<hr />\r\n\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n\r\n<hr />\r\n\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n\r\n<hr />\r\n\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n\r\n<hr />\r\n\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n\r\n<hr />\r\n\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n\r\n<hr />\r\n\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n\r\n<hr />\r\n\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n\r\n<hr />\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n\r\n<hr />\r\n\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n\r\n<hr />\r\n\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n\r\n<hr />\r\n\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n\r\n<hr />\r\n\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n\r\n<hr />\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n\r\n<hr />\r\n\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n\r\n<hr />\r\n\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n\r\n<hr />\r\n\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n\r\n<hr />\r\n\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n\r\n<hr />\r\n\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n\r\n<hr />\r\n\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n\r\n<hr />\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']\r\n\r\n[av_iconlist position=\'left\' font_color=\'\' custom_title=\'\' custom_content=\'\' color=\'\' custom_bg=\'\' custom_font=\'\' custom_border=\'\']\r\n[av_iconlist_item title=\'List Title 1\' icon=\'43\' content=\'Enter content here\']\r\n[av_iconlist_item title=\'List Title 2\' icon=\'25\' content=\'Enter content here\']\r\n[av_iconlist_item title=\'List Title 3\' icon=\'64\' content=\'Enter content here\']\r\n[/av_iconlist]\r\n\r\n");
INSERT INTO `wp_postmeta` VALUES("139", "10", "_avia_builder_shortcode_tree", "a:9:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:2;}i:2;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:4;}}s:5:\"index\";i:3;}i:3;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:5;}i:4;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:7;}}s:5:\"index\";i:6;}i:5;a:3:{s:3:\"tag\";s:10:\"av_heading\";s:7:\"content\";a:0:{}s:5:\"index\";i:8;}i:6;a:3:{s:3:\"tag\";s:11:\"av_one_full\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:10;}}s:5:\"index\";i:9;}i:7;a:3:{s:3:\"tag\";s:5:\"av_hr\";s:7:\"content\";a:0:{}s:5:\"index\";i:11;}i:8;a:3:{s:3:\"tag\";s:11:\"av_iconlist\";s:7:\"content\";a:0:{}s:5:\"index\";i:12;}}");
INSERT INTO `wp_postmeta` VALUES("140", "10", "layout", "");
INSERT INTO `wp_postmeta` VALUES("141", "10", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("142", "10", "footer", "");
INSERT INTO `wp_postmeta` VALUES("143", "10", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("144", "10", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("145", "10", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("146", "60", "_wp_attached_file", "2014/11/51b3cb4f1e43a18904.jpg");
INSERT INTO `wp_postmeta` VALUES("147", "60", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:430;s:4:\"file\";s:30:\"2014/11/51b3cb4f1e43a18904.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"51b3cb4f1e43a18904-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"51b3cb4f1e43a18904-300x86.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"51b3cb4f1e43a18904-1030x295.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:28:\"51b3cb4f1e43a18904-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-845x430.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-710x375.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-705x202.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-845x321.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:321;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:31:\"51b3cb4f1e43a18904-1210x423.jpg\";s:5:\"width\";i:1210;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-450x430.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:30:\"51b3cb4f1e43a18904-450x129.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:129;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("148", "61", "_wp_attached_file", "2014/11/1022058_59074159.jpg");
INSERT INTO `wp_postmeta` VALUES("149", "61", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:430;s:4:\"file\";s:28:\"2014/11/1022058_59074159.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"1022058_59074159-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"1022058_59074159-300x86.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"1022058_59074159-1030x295.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"1022058_59074159-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-845x430.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-710x375.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-705x202.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-845x321.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:321;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"1022058_59074159-1210x423.jpg\";s:5:\"width\";i:1210;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-450x430.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"1022058_59074159-450x129.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:129;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("150", "62", "_wp_attached_file", "2014/11/1072216_52298388.jpg");
INSERT INTO `wp_postmeta` VALUES("151", "62", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:430;s:4:\"file\";s:28:\"2014/11/1072216_52298388.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"1072216_52298388-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"1072216_52298388-300x86.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"1072216_52298388-1030x295.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"1072216_52298388-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-845x430.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-710x375.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-705x202.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-845x321.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:321;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"1072216_52298388-1210x423.jpg\";s:5:\"width\";i:1210;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-450x430.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"1072216_52298388-450x129.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:129;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("152", "63", "_wp_attached_file", "2014/11/1169213_21767800.jpg");
INSERT INTO `wp_postmeta` VALUES("153", "63", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:430;s:4:\"file\";s:28:\"2014/11/1169213_21767800.jpg\";s:5:\"sizes\";a:15:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"1169213_21767800-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"1169213_21767800-300x86.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:86;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"1169213_21767800-1030x295.jpg\";s:5:\"width\";i:1030;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"1169213_21767800-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-845x430.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-710x375.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-705x202.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-845x321.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:321;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:29:\"1169213_21767800-1210x423.jpg\";s:5:\"width\";i:1210;s:6:\"height\";i:423;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-450x430.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:430;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"1169213_21767800-450x129.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:129;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("154", "1", "_edit_lock", "1416886506:1");
INSERT INTO `wp_postmeta` VALUES("155", "1", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("158", "1", "layout", "");
INSERT INTO `wp_postmeta` VALUES("159", "1", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("160", "1", "footer", "");
INSERT INTO `wp_postmeta` VALUES("161", "1", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("162", "1", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("163", "1", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("164", "68", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("165", "68", "_edit_lock", "1416886528:1");
INSERT INTO `wp_postmeta` VALUES("168", "68", "layout", "");
INSERT INTO `wp_postmeta` VALUES("169", "68", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("170", "68", "footer", "");
INSERT INTO `wp_postmeta` VALUES("171", "68", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("172", "68", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("173", "68", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("174", "70", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("175", "70", "_edit_lock", "1416886741:1");
INSERT INTO `wp_postmeta` VALUES("178", "70", "layout", "");
INSERT INTO `wp_postmeta` VALUES("179", "70", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("180", "70", "footer", "");
INSERT INTO `wp_postmeta` VALUES("181", "70", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("182", "70", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("183", "70", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("194", "75", "_wp_attached_file", "2015/01/arc-engineering-logo-direction.jpg");
INSERT INTO `wp_postmeta` VALUES("195", "75", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:689;s:6:\"height\";i:165;s:4:\"file\";s:42:\"2015/01/arc-engineering-logo-direction.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"arc-engineering-logo-direction-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"arc-engineering-logo-direction-300x72.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:72;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:40:\"arc-engineering-logo-direction-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:42:\"arc-engineering-logo-direction-180x165.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:42:\"arc-engineering-logo-direction-495x165.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:42:\"arc-engineering-logo-direction-260x165.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:42:\"arc-engineering-logo-direction-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:42:\"arc-engineering-logo-direction-450x165.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:165;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:42:\"arc-engineering-logo-direction-450x108.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:108;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("196", "89", "_wp_attached_file", "2014/11/art.jpg");
INSERT INTO `wp_postmeta` VALUES("197", "89", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:15:\"2014/11/art.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"art-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"art-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:15:\"art-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"art-200x185.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"art-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("198", "90", "_wp_attached_file", "2014/11/brad.jpg");
INSERT INTO `wp_postmeta` VALUES("199", "90", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:16:\"2014/11/brad.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"brad-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:14:\"brad-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:16:\"brad-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:16:\"brad-200x185.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:16:\"brad-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("200", "94", "_wp_attached_file", "2014/11/pathstone.jpg");
INSERT INTO `wp_postmeta` VALUES("201", "94", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:259;s:6:\"height\";i:194;s:4:\"file\";s:21:\"2014/11/pathstone.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"pathstone-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"pathstone-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:21:\"pathstone-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:21:\"pathstone-259x185.jpg\";s:5:\"width\";i:259;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"pathstone-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("202", "95", "_wp_attached_file", "2014/11/district-school-bd-niagara.jpg");
INSERT INTO `wp_postmeta` VALUES("203", "95", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:251;s:6:\"height\";i:201;s:4:\"file\";s:38:\"2014/11/district-school-bd-niagara.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"district-school-bd-niagara-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:36:\"district-school-bd-niagara-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:38:\"district-school-bd-niagara-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:38:\"district-school-bd-niagara-251x185.jpg\";s:5:\"width\";i:251;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:38:\"district-school-bd-niagara-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("204", "96", "_wp_attached_file", "2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table.jpg");
INSERT INTO `wp_postmeta` VALUES("205", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:380;s:6:\"height\";i:307;s:4:\"file\";s:89:\"2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:87:\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:89:\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-300x242.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:242;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:87:\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:89:\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:89:\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-260x185.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:89:\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("206", "100", "_wp_attached_file", "2015/01/niagara-housing.jpg");
INSERT INTO `wp_postmeta` VALUES("207", "100", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:137;s:6:\"height\";i:94;s:4:\"file\";s:27:\"2015/01/niagara-housing.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"niagara-housing-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:25:\"niagara-housing-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:26:\"niagara-housing-120x94.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:94;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("208", "101", "_wp_attached_file", "2015/01/gryphin.jpg");
INSERT INTO `wp_postmeta` VALUES("209", "101", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:271;s:6:\"height\";i:180;s:4:\"file\";s:19:\"2015/01/gryphin.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"gryphin-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"gryphin-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"gryphin-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"gryphin-260x180.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"gryphin-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("210", "102", "_wp_attached_file", "2014/11/winery.png");
INSERT INTO `wp_postmeta` VALUES("211", "102", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:190;s:6:\"height\";i:165;s:4:\"file\";s:18:\"2014/11/winery.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"winery-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"winery-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"winery-180x165.png\";s:5:\"width\";i:180;s:6:\"height\";i:165;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"winery-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("212", "24", "_aviaLayoutBuilder_active", "");
INSERT INTO `wp_postmeta` VALUES("213", "24", "_aviaLayoutBuilderCleanData", "");
INSERT INTO `wp_postmeta` VALUES("214", "24", "layout", "");
INSERT INTO `wp_postmeta` VALUES("215", "24", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("216", "24", "footer", "");
INSERT INTO `wp_postmeta` VALUES("217", "24", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("218", "24", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("219", "24", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("220", "129", "_wp_attached_file", "2015/02/arclogo.png");
INSERT INTO `wp_postmeta` VALUES("221", "129", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:83;s:4:\"file\";s:19:\"2015/02/arclogo.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"arclogo-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"arclogo-300x55.png\";s:5:\"width\";i:300;s:6:\"height\";i:55;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"arclogo-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"arclogo-180x83.png\";s:5:\"width\";i:180;s:6:\"height\";i:83;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"arclogo-260x83.png\";s:5:\"width\";i:260;s:6:\"height\";i:83;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"arclogo-120x83.png\";s:5:\"width\";i:120;s:6:\"height\";i:83;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"arclogo-450x83.png\";s:5:\"width\";i:450;s:6:\"height\";i:83;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"arclogo-450x83.png\";s:5:\"width\";i:450;s:6:\"height\";i:83;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("222", "130", "_edit_lock", "1423620587:1");
INSERT INTO `wp_postmeta` VALUES("223", "130", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("224", "130", "_aviaLayoutBuilder_active", "active");
INSERT INTO `wp_postmeta` VALUES("225", "130", "_aviaLayoutBuilderCleanData", "[av_one_half first]\r\n\r\n[av_image src=\'http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\' attachment=\'94\' attachment_size=\'full\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\' styling=\'\' caption=\'\' font_size=\'\' appearance=\'\'][/av_image]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nPathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n[/av_textblock]\r\n\r\n[/av_one_half]");
INSERT INTO `wp_postmeta` VALUES("226", "130", "_avia_builder_shortcode_tree", "a:2:{i:0;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:8:\"av_image\";s:7:\"content\";a:0:{}s:5:\"index\";i:1;}}s:5:\"index\";i:0;}i:1;a:3:{s:3:\"tag\";s:11:\"av_one_half\";s:7:\"content\";a:1:{i:0;a:3:{s:3:\"tag\";s:12:\"av_textblock\";s:7:\"content\";a:0:{}s:5:\"index\";i:3;}}s:5:\"index\";i:2;}}");
INSERT INTO `wp_postmeta` VALUES("227", "130", "_portfolio_custom_link", "");
INSERT INTO `wp_postmeta` VALUES("228", "130", "_portfolio_custom_link_url", "http://");
INSERT INTO `wp_postmeta` VALUES("229", "130", "_preview_ids", "");
INSERT INTO `wp_postmeta` VALUES("230", "130", "_preview_display", "gallery");
INSERT INTO `wp_postmeta` VALUES("231", "130", "_preview_autorotation", "disabled");
INSERT INTO `wp_postmeta` VALUES("232", "130", "_preview_columns", "6");
INSERT INTO `wp_postmeta` VALUES("233", "130", "_preview_text", "");
INSERT INTO `wp_postmeta` VALUES("234", "130", "layout", "");
INSERT INTO `wp_postmeta` VALUES("235", "130", "sidebar", "");
INSERT INTO `wp_postmeta` VALUES("236", "130", "footer", "");
INSERT INTO `wp_postmeta` VALUES("237", "130", "header_title_bar", "");
INSERT INTO `wp_postmeta` VALUES("238", "130", "header_transparency", "");
INSERT INTO `wp_postmeta` VALUES("239", "130", "breadcrumb_parent", "131");
INSERT INTO `wp_postmeta` VALUES("240", "130", "_avia_hide_featured_image", "0");
INSERT INTO `wp_postmeta` VALUES("253", "130", "_thumbnail_id", "94");
INSERT INTO `wp_postmeta` VALUES("254", "134", "_wp_attached_file", "2014/11/image1.jpg");
INSERT INTO `wp_postmeta` VALUES("255", "134", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:136;s:4:\"file\";s:18:\"2014/11/image1.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image1-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image1-180x136.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:136;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image1-495x136.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:136;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image1-260x136.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:136;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image1-450x136.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:136;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image1-450x122.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:122;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("256", "135", "_wp_attached_file", "2014/11/image2.jpg");
INSERT INTO `wp_postmeta` VALUES("257", "135", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image2.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image2-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image2-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image2-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image2-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image2-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image2-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image2-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("258", "136", "_wp_attached_file", "2014/11/image3.jpg");
INSERT INTO `wp_postmeta` VALUES("259", "136", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image3.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image3-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image3-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image3-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image3-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image3-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image3-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image3-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image3-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image3-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("260", "137", "_wp_attached_file", "2014/11/image4.jpg");
INSERT INTO `wp_postmeta` VALUES("261", "137", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image4.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image4-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image4-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image4-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image4-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image4-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image4-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image4-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image4-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image4-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("262", "138", "_wp_attached_file", "2014/11/image5.jpg");
INSERT INTO `wp_postmeta` VALUES("263", "138", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image5.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image5-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image5-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image5-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image5-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image5-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image5-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image5-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image5-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image5-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("264", "139", "_wp_attached_file", "2014/11/image6.jpg");
INSERT INTO `wp_postmeta` VALUES("265", "139", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image6.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image6-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image6-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image6-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image6-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image6-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image6-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image6-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image6-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image6-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("266", "140", "_wp_attached_file", "2014/11/image7.jpg");
INSERT INTO `wp_postmeta` VALUES("267", "140", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image7.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image7-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image7-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image7-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image7-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image7-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image7-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image7-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image7-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image7-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("268", "141", "_wp_attached_file", "2014/11/image8.jpg");
INSERT INTO `wp_postmeta` VALUES("269", "141", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:137;s:4:\"file\";s:18:\"2014/11/image8.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"image8-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"image8-300x82.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:16:\"image8-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:18:\"image8-180x137.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:18:\"image8-495x137.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:18:\"image8-260x137.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:18:\"image8-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:18:\"image8-450x137.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:18:\"image8-450x123.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("270", "145", "_wp_attached_file", "2015/02/arclogo1.png");
INSERT INTO `wp_postmeta` VALUES("271", "145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:150;s:4:\"file\";s:20:\"2015/02/arclogo1.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"arclogo1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"arclogo1-300x100.png\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"arclogo1-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"arclogo1-180x150.png\";s:5:\"width\";i:180;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"arclogo1-260x150.png\";s:5:\"width\";i:260;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"arclogo1-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"arclogo1-450x150.png\";s:5:\"width\";i:450;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"arclogo1-450x150.png\";s:5:\"width\";i:450;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("272", "146", "_wp_attached_file", "2015/02/arclogo2.png");
INSERT INTO `wp_postmeta` VALUES("273", "146", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:450;s:6:\"height\";i:126;s:4:\"file\";s:20:\"2015/02/arclogo2.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"arclogo2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"arclogo2-300x84.png\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"arclogo2-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"arclogo2-180x126.png\";s:5:\"width\";i:180;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"arclogo2-260x126.png\";s:5:\"width\";i:260;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"arclogo2-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:20:\"arclogo2-450x126.png\";s:5:\"width\";i:450;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"arclogo2-450x126.png\";s:5:\"width\";i:450;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("278", "162", "_wp_attached_file", "2015/02/burloak-stack-cropped.jpg");
INSERT INTO `wp_postmeta` VALUES("279", "162", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:909;s:6:\"height\";i:173;s:4:\"file\";s:33:\"2015/02/burloak-stack-cropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"burloak-stack-cropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"burloak-stack-cropped-300x57.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:57;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:31:\"burloak-stack-cropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-180x173.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-495x173.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-260x173.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-845x173.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-710x173.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-705x134.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:134;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-845x173.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"burloak-stack-cropped-450x173.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"burloak-stack-cropped-450x86.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:86;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("280", "163", "_wp_attached_file", "2014/11/cogencropped.jpg");
INSERT INTO `wp_postmeta` VALUES("281", "163", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:24:\"2014/11/cogencropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"cogencropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"cogencropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"cogencropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"cogencropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"cogencropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"cogencropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:24:\"cogencropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:24:\"cogencropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"cogencropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"cogencropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"cogencropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"cogencropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:23:\"cogencropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("282", "166", "_wp_attached_file", "2014/11/cogencropped1.jpg");
INSERT INTO `wp_postmeta` VALUES("283", "166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:25:\"2014/11/cogencropped1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"cogencropped1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"cogencropped1-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:23:\"cogencropped1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:25:\"cogencropped1-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:25:\"cogencropped1-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:25:\"cogencropped1-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:25:\"cogencropped1-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:25:\"cogencropped1-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:25:\"cogencropped1-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:25:\"cogencropped1-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:25:\"cogencropped1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:25:\"cogencropped1-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"cogencropped1-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("284", "167", "_wp_attached_file", "2014/11/controlsystemscropped.jpg");
INSERT INTO `wp_postmeta` VALUES("285", "167", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:33:\"2014/11/controlsystemscropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"controlsystemscropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"controlsystemscropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:31:\"controlsystemscropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:33:\"controlsystemscropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:32:\"controlsystemscropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("286", "168", "_wp_attached_file", "2014/11/labcropped.jpg");
INSERT INTO `wp_postmeta` VALUES("287", "168", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:22:\"2014/11/labcropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"labcropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"labcropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:20:\"labcropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:22:\"labcropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:22:\"labcropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:22:\"labcropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:22:\"labcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:22:\"labcropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:22:\"labcropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:22:\"labcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:22:\"labcropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:22:\"labcropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:21:\"labcropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("288", "170", "_wp_attached_file", "2014/11/cranecopped.jpg");
INSERT INTO `wp_postmeta` VALUES("289", "170", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:23:\"2014/11/cranecopped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"cranecopped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"cranecopped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:21:\"cranecopped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:23:\"cranecopped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:23:\"cranecopped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:23:\"cranecopped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:23:\"cranecopped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:23:\"cranecopped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:23:\"cranecopped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:23:\"cranecopped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:23:\"cranecopped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:23:\"cranecopped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:22:\"cranecopped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("290", "171", "_wp_attached_file", "2014/11/building1cropped.jpg");
INSERT INTO `wp_postmeta` VALUES("291", "171", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:28:\"2014/11/building1cropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"building1cropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"building1cropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"building1cropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"building1cropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"building1cropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"building1cropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"building1cropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:28:\"building1cropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"building1cropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"building1cropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"building1cropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"building1cropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:27:\"building1cropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("292", "172", "_wp_attached_file", "2014/11/building1cropped1.jpg");
INSERT INTO `wp_postmeta` VALUES("293", "172", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:29:\"2014/11/building1cropped1.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"building1cropped1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"building1cropped1-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"building1cropped1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"building1cropped1-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"building1cropped1-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"building1cropped1-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"building1cropped1-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:29:\"building1cropped1-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"building1cropped1-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"building1cropped1-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"building1cropped1-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"building1cropped1-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"building1cropped1-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("294", "174", "_wp_attached_file", "2014/11/engineeingmeetingcropped.jpg");
INSERT INTO `wp_postmeta` VALUES("295", "174", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:899;s:6:\"height\";i:175;s:4:\"file\";s:36:\"2014/11/engineeingmeetingcropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"engineeingmeetingcropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"engineeingmeetingcropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:34:\"engineeingmeetingcropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:36:\"engineeingmeetingcropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:35:\"engineeingmeetingcropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("296", "175", "_wp_attached_file", "2014/11/drawingandmodelcropped.jpg");
INSERT INTO `wp_postmeta` VALUES("297", "175", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:899;s:6:\"height\";i:175;s:4:\"file\";s:34:\"2014/11/drawingandmodelcropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"drawingandmodelcropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"drawingandmodelcropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:32:\"drawingandmodelcropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:34:\"drawingandmodelcropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:33:\"drawingandmodelcropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("298", "176", "_wp_attached_file", "2014/11/engdrawingcropped.jpg");
INSERT INTO `wp_postmeta` VALUES("299", "176", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:900;s:6:\"height\";i:175;s:4:\"file\";s:29:\"2014/11/engdrawingcropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"engdrawingcropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"engdrawingcropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:27:\"engdrawingcropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:29:\"engdrawingcropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:28:\"engdrawingcropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("300", "177", "_wp_attached_file", "2014/11/wordchartcropped.jpg");
INSERT INTO `wp_postmeta` VALUES("301", "177", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:899;s:6:\"height\";i:175;s:4:\"file\";s:28:\"2014/11/wordchartcropped.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"wordchartcropped-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"wordchartcropped-300x58.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:58;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:26:\"wordchartcropped-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"square\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-180x175.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-495x175.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-260x175.jpg\";s:5:\"width\";i:260;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"gallery\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-710x175.jpg\";s:5:\"width\";i:710;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-705x137.jpg\";s:5:\"width\";i:705;s:6:\"height\";i:137;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-845x175.jpg\";s:5:\"width\";i:845;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-120x120.jpg\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:28:\"wordchartcropped-450x175.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:27:\"wordchartcropped-450x88.jpg\";s:5:\"width\";i:450;s:6:\"height\";i:88;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("302", "181", "_wp_attached_file", "2015/04/ARC_Logo.png");
INSERT INTO `wp_postmeta` VALUES("303", "181", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:289;s:6:\"height\";i:59;s:4:\"file\";s:20:\"2015/04/ARC_Logo.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ARC_Logo-80x59.png\";s:5:\"width\";i:80;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"ARC_Logo-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:19:\"ARC_Logo-180x59.png\";s:5:\"width\";i:180;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"ARC_Logo-260x59.png\";s:5:\"width\";i:260;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"ARC_Logo-120x59.png\";s:5:\"width\";i:120;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("304", "182", "_wp_attached_file", "2015/04/ARC_Logo1.png");
INSERT INTO `wp_postmeta` VALUES("305", "182", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:289;s:6:\"height\";i:75;s:4:\"file\";s:21:\"2015/04/ARC_Logo1.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"ARC_Logo1-80x75.png\";s:5:\"width\";i:80;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:19:\"ARC_Logo1-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:20:\"ARC_Logo1-180x75.png\";s:5:\"width\";i:180;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"ARC_Logo1-260x75.png\";s:5:\"width\";i:260;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"ARC_Logo1-120x75.png\";s:5:\"width\";i:120;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_postmeta` VALUES("306", "186", "_wp_attached_file", "2015/04/logo5-long-1.png");
INSERT INTO `wp_postmeta` VALUES("307", "186", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:709;s:6:\"height\";i:567;s:4:\"file\";s:24:\"2015/04/logo5-long-1.png\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"logo5-long-1-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-300x240.png\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:22:\"logo5-long-1-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"square\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"featured\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-709x430.png\";s:5:\"width\";i:709;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-260x185.png\";s:5:\"width\";i:260;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"magazine\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-709x375.png\";s:5:\"width\";i:709;s:6:\"height\";i:375;s:9:\"mime-type\";s:9:\"image/png\";}s:7:\"masonry\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-705x564.png\";s:5:\"width\";i:705;s:6:\"height\";i:564;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"entry_with_sidebar\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-709x321.png\";s:5:\"width\";i:709;s:6:\"height\";i:321;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"entry_without_sidebar\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-709x423.png\";s:5:\"width\";i:709;s:6:\"height\";i:423;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-120x120.png\";s:5:\"width\";i:120;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-450x450.png\";s:5:\"width\";i:450;s:6:\"height\";i:450;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:24:\"logo5-long-1-450x360.png\";s:5:\"width\";i:450;s:6:\"height\";i:360;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2013-03-30 01:25:20", "2013-03-30 01:25:20", "Lost in the shuffle during our move was the announcement of some new staff. Howard Roberts, M.Eng, MBA, P.Eng and Dan McNiven, P.Eng have joined our staff in the roles of Project Managers. Both have extensive experience in the Consulting industry, and bring years of combined knowledge and expertise to our team. Welcome aboard!", "March 30, 2013", "", "publish", "closed", "closed", "", "hello-world", "", "", "2014-11-25 03:37:25", "2014-11-25 03:37:25", "", "0", "http://sightseer.ca/arcengineering/?p=1", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("2", "1", "2014-11-25 01:25:20", "2014-11-25 01:25:20", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'166\'][/av_slide_full]\r\n[av_slide_full id=\'167\'][/av_slide_full]\r\n[av_slide_full id=\'168\'][/av_slide_full]\r\n[av_slide_full id=\'162\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "publish", "open", "open", "", "sample-page", "", "", "2015-02-17 17:08:48", "2015-02-17 17:08:48", "", "0", "http://sightseer.ca/arcengineering/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("4", "1", "2014-11-25 01:26:05", "2014-11-25 01:26:05", "", "Home", "", "inherit", "open", "open", "", "2-revision-v1", "", "", "2014-11-25 01:26:05", "2014-11-25 01:26:05", "", "2", "http://sightseer.ca/arcengineering/?p=4", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2014-11-25 01:29:11", "2014-11-25 01:29:11", "[av_one_half first]\r\n\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'62\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'140\'][/av_slide]\r\n[av_slide id=\'141\'][/av_slide]\r\n[av_slide id=\'137\'][/av_slide]\r\n[av_slide id=\'134\'][/av_slide]\r\n[/av_slideshow]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\"  wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"150\" height=\"150\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\"  wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"150\" height=\"150\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "publish", "open", "open", "", "about-us", "", "", "2015-02-17 16:37:39", "2015-02-17 16:37:39", "", "0", "http://sightseer.ca/arcengineering/?page_id=5", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2014-11-25 01:29:11", "2014-11-25 01:29:11", "<h1>History</h1>\r\n\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n\r\n<p>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.</p>\r\n\r\n<p>In 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.</p>\r\n\r\n<p>Art left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities</p>\r\n\r\n<p>In 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.</p>\r\n<p>Art joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.</p>\r\n\r\n<p>Following start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.</p>\r\n\r\n<p>In September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.</p>\r\n\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\n\r\n<p>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.</p>\r\n\r\n<p>Brad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.</p>\r\n\r\n<p>Brad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.</p>\r\n\r\n<p>Brad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.</p>\r\n\r\n<p>His next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.</p>\r\n\r\n<p>In September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.</p>\r\n\r\n<h5>Today</h5>\r\n\r\n<p>We have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.</p>\r\n\r\n<p>We look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.</p>", "About Us", "", "inherit", "open", "open", "", "5-revision-v1", "", "", "2014-11-25 01:29:11", "2014-11-25 01:29:11", "", "5", "http://sightseer.ca/arcengineering/?p=6", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2014-11-25 01:32:20", "2014-11-25 01:32:20", "<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>", "Home", "", "inherit", "open", "open", "", "2-revision-v1", "", "", "2014-11-25 01:32:20", "2014-11-25 01:32:20", "", "2", "http://sightseer.ca/arcengineering/?p=7", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2014-11-25 01:34:40", "2014-11-25 01:34:40", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'177\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'176\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'175\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'174\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Services</h3>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Partnerships</h3>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]", "Services", "", "publish", "open", "open", "", "services", "", "", "2015-02-17 17:57:42", "2015-02-17 17:57:42", "", "0", "http://sightseer.ca/arcengineering/?page_id=8", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2014-11-25 01:34:40", "2014-11-25 01:34:40", "<h2>Services</h2>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n<h2>Partnerships</h2>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.", "Services", "", "inherit", "open", "open", "", "8-revision-v1", "", "", "2014-11-25 01:34:40", "2014-11-25 01:34:40", "", "8", "http://sightseer.ca/arcengineering/?p=9", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2014-11-25 01:43:37", "2014-11-25 01:43:37", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n\r\n<hr />\r\n\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n\r\n<hr />\r\n\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n\r\n<hr />\r\n\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n\r\n<hr />\r\n\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n\r\n<hr />\r\n\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n\r\n<hr />\r\n\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n\r\n<hr />\r\n\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n\r\n<hr />\r\n\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n\r\n<hr />\r\n\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n\r\n<hr />\r\n\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n\r\n<hr />\r\n\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n\r\n<hr />\r\n\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n\r\n<hr />\r\n\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n\r\n<hr />\r\n\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n\r\n<hr />\r\n\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n\r\n<hr />\r\n\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n\r\n<hr />\r\n\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n\r\n<hr />\r\n\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']\r\n\r\n[av_iconlist position=\'left\' font_color=\'\' custom_title=\'\' custom_content=\'\' color=\'\' custom_bg=\'\' custom_font=\'\' custom_border=\'\']\r\n[av_iconlist_item title=\'List Title 1\' icon=\'43\' content=\'Enter content here\']\r\n[av_iconlist_item title=\'List Title 2\' icon=\'25\' content=\'Enter content here\']\r\n[av_iconlist_item title=\'List Title 3\' icon=\'64\' content=\'Enter content here\']\r\n[/av_iconlist]", "Portfolio", "", "publish", "open", "closed", "", "portfolio", "", "", "2015-02-11 02:37:03", "2015-02-11 02:37:03", "", "0", "http://sightseer.ca/arcengineering/?page_id=10", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2014-11-25 01:43:37", "2014-11-25 01:43:37", "The following brochures give an overview of some sector specific projects we have been working on:\r\n\r\nCommercial      Educational       Health Care       Industrial       LEED and Energy Services\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\nPathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\nWe are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project", "Portfolio", "", "inherit", "open", "open", "", "10-revision-v1", "", "", "2014-11-25 01:43:37", "2014-11-25 01:43:37", "", "10", "http://sightseer.ca/arcengineering/?p=11", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2014-11-25 01:44:19", "2014-11-25 01:44:19", "", "ARC Brochure Commercial", "", "inherit", "open", "open", "", "arc-brochure-commercial", "", "", "2014-11-25 01:45:03", "2014-11-25 01:45:03", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2014-11-25 01:44:20", "2014-11-25 01:44:20", "", "Educational", "", "inherit", "open", "open", "", "arc-brochure-educational", "", "", "2014-11-25 01:45:18", "2014-11-25 01:45:18", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2014-11-25 01:44:21", "2014-11-25 01:44:21", "", "Health Care", "", "inherit", "open", "open", "", "arc-brochure-healthcare", "", "", "2014-11-25 01:45:29", "2014-11-25 01:45:29", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2014-11-25 01:44:21", "2014-11-25 01:44:21", "", "Industrial", "", "inherit", "open", "open", "", "arc-brochure-industrial", "", "", "2014-11-25 01:45:38", "2014-11-25 01:45:38", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2014-11-25 01:44:22", "2014-11-25 01:44:22", "", "LEED and Energy Services", "", "inherit", "open", "open", "", "arc-brochure-leed-energy", "", "", "2014-11-25 01:46:11", "2014-11-25 01:46:11", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2014-11-25 01:44:23", "2014-11-25 01:44:23", "", "Mechanical Designer", "", "inherit", "open", "open", "", "designer", "", "", "2014-11-25 01:56:43", "2014-11-25 01:56:43", "", "24", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Designer.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2014-11-25 01:44:23", "2014-11-25 01:44:23", "", "Mechanical Technologist", "", "inherit", "open", "open", "", "technologist", "", "", "2014-11-25 01:56:52", "2014-11-25 01:56:52", "", "24", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Technologist.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2015-02-11 02:35:32", "2015-02-11 02:35:32", "[av_one_full first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nThe following brochures give an overview of some sector specific projects we have been working on:\n\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\n\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\n[/av_textblock]\n[/av_one_full]\n\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\n\n[av_one_full first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\n\n<hr />\n\n<h5>Wingbury Properties, Dundas, Ontario</h5>\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\n\n<hr />\n\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\n\n<hr />\n\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\n\n<hr />\n\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\n\n<hr />\n\n<h5>Actlabs, Ancaster, Ontario</h5>\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\n\n<hr />\n\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\n\n<hr />\n\n<h5>Alton Village, Burlington, Ontario</h5>\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\n\n<hr />\n\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\n\n<hr />\n\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\n\n<hr />\n\n[/av_textblock]\n[/av_one_full]\n\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\n\n[av_one_full first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\n\n<hr />\n\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\n\n<hr />\n\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\n\n<hr />\n\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\n\n<hr />\n\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\nBoiler venting modifications.\n\n<hr />\n\n<h5>Pearson Airport. Toronto, Ontario</h5>\nGTAA Fueling System\n\n<hr />\n\n<h5>Project Management - JNE Consulting Engineering</h5>\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\n\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\n\nSubconsulting for ISO 9000 Certification Planning and Implementation\n\nSubconsulting on Stelco By-Products Misa Project\n\n<hr />\n\n[/av_textblock]\n[/av_one_full]\n\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\n\n[av_one_full first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\n\n<hr />\n\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\n\n<hr />\n\n<h5>Niagara College, St. Catharines, Ontario</h5>\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\n\n<hr />\n\n<h5>Brock University, St .Catharines, Ontario</h5>\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\n\n<hr />\n\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\n\n<hr />\n\n<h5>McMaster University, Hamilton, Ontario</h5>\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\n\n<hr />\n\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\n\n<hr />\n\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\n\n<hr />\n\n<h5>Ridley College, St. Catharines, Ontario</h5>\nChapel Heating Retrofit\n\nAquatic Centre HVAC Renovation\n\nGymnasium Weight Training Area Retrofit\n\nScience Room area Retrofit\n\n<hr />\n\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\nBoiler Burner Retrofit\n\nDomestic Hot Water Plant Retrofit\n\n<hr />\n\n[/av_textblock]\n[/av_one_full]\n\n[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']\n\n[av_iconlist position=\'left\' font_color=\'\' custom_title=\'\' custom_content=\'\' color=\'\' custom_bg=\'\' custom_font=\'\' custom_border=\'\']\n[av_iconlist_item title=\'List Title 1\' icon=\'43\' content=\'Enter content here\']\n[av_iconlist_item title=\'List Title 2\' icon=\'25\' content=\'Enter content here\']\n[av_iconlist_item title=\'List Title 3\' icon=\'64\' content=\'Enter content here\']\n[/av_iconlist]", "Portfolio", "", "inherit", "open", "open", "", "10-autosave-v1", "", "", "2015-02-11 02:35:32", "2015-02-11 02:35:32", "", "10", "http://sightseer.ca/arcengineering/?p=19", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2014-11-25 01:46:13", "2014-11-25 01:46:13", "The following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a>      <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a>       <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a>       <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a>       <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\nPathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\nWe are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project", "Portfolio", "", "inherit", "open", "open", "", "10-revision-v1", "", "", "2014-11-25 01:46:13", "2014-11-25 01:46:13", "", "10", "http://sightseer.ca/arcengineering/?p=20", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2014-11-25 01:52:03", "2014-11-25 01:52:03", "[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Address</h5>\r\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\r\n\r\nPhone: (905) 643-8530 Fax: (905) 643-8510\r\n\r\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<!-- Google Map of location-->\r\n<iframe src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\r\n\r\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Address</h5>\r\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\r\n\r\nPhone: (905) 643-8530 Fax: (905) 643-8510\r\n\r\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\r\n\r\n<!-- Google Map of location-->\r\n<iframe src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\r\n\r\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\r\n[/av_textblock]", "Contact Us", "", "publish", "open", "open", "", "contact-us", "", "", "2014-11-25 03:14:41", "2014-11-25 03:14:41", "", "0", "http://sightseer.ca/arcengineering/?page_id=21", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2014-11-25 01:52:03", "2014-11-25 01:52:03", "<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>", "Contact Us", "", "inherit", "open", "open", "", "21-revision-v1", "", "", "2014-11-25 01:52:03", "2014-11-25 01:52:03", "", "21", "http://sightseer.ca/arcengineering/?p=22", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2014-11-25 01:53:48", "2014-11-25 01:53:48", "<h5>Address</h5>\r\n<p>1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5</p>\r\n<p>Phone: (905) 643-8530 Fax: (905) 643-8510</p>\r\n<p>Email: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a></p>\r\n\r\n<!-- Google Map of location-->\r\n<iframe scrolling=\"yes\" marginheight=\"0\" marginwidth=\"0\" src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" frameborder=\"0\" height=\"290\" width=\"375\"></iframe>\r\n<br><small><a href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\" style=\"color:#0000FF;text-align:left\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>", "Contact Us", "", "inherit", "open", "open", "", "21-revision-v1", "", "", "2014-11-25 01:53:48", "2014-11-25 01:53:48", "", "21", "http://sightseer.ca/arcengineering/?p=23", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2014-11-25 01:56:53", "2014-11-25 01:56:53", "<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table.jpg\"><img class=\"  wp-image-96 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-300x242.jpg\" alt=\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table\" width=\"226\" height=\"182\" /></a>Since opening our doors in 2010, we have expanded our client base and are currently looking for skilled, accomplished and motivated professional engineers, designers, and technologists to join our team.\r\n\r\nWe have the following positions open: <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Designer.pdf\">Mechanical Designer</a> and <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Technologist.pdf\">Mechanical Technologist</a>. Please apply in person at:\r\n1100 South Service Rd., Suite #417\r\nStoney Creek, ON L8E 0C5\r\n\r\nPlease click <a href=\"mailto:contact@arcengineering.ca\">here</a> to submit your resume or for any employment queries.", "Careers", "", "publish", "closed", "open", "", "careers", "", "", "2015-01-09 15:37:28", "2015-01-09 15:37:28", "", "0", "http://sightseer.ca/arcengineering/?page_id=24", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2014-11-25 01:56:53", "2014-11-25 01:56:53", "Since opening our doors in 2010, we have expanded our client base and are currently looking for skilled, accomplished and motivated professional engineers, designers, and technologists to join our team.\r\n\r\nWe have the following positions open: <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Designer.pdf\">Mechanical Designer</a> and <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Technologist.pdf\">Mechanical Technologist</a>. Please apply in person at:\r\n1100 South Service Rd., Suite #417\r\nStoney Creek, ON L8E 0C5\r\n\r\nPlease click <a href=\"mailto:contact@arcengineering.ca\">here</a> to submit your resume or for any employment queries.", "Careers", "", "inherit", "closed", "open", "", "24-revision-v1", "", "", "2014-11-25 01:56:53", "2014-11-25 01:56:53", "", "24", "http://sightseer.ca/arcengineering/?p=25", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2014-11-25 02:04:48", "2014-11-25 02:04:48", " ", "", "", "publish", "closed", "open", "", "26", "", "", "2014-11-25 02:04:48", "2014-11-25 02:04:48", "", "0", "http://sightseer.ca/arcengineering/?p=26", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2014-11-25 02:04:48", "2014-11-25 02:04:48", " ", "", "", "publish", "closed", "open", "", "27", "", "", "2014-11-25 02:04:48", "2014-11-25 02:04:48", "", "0", "http://sightseer.ca/arcengineering/?p=27", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2014-11-25 02:04:48", "2014-11-25 02:04:48", " ", "", "", "publish", "closed", "open", "", "28", "", "", "2014-11-25 02:04:48", "2014-11-25 02:04:48", "", "0", "http://sightseer.ca/arcengineering/?p=28", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2014-11-25 02:04:48", "2014-11-25 02:04:48", " ", "", "", "publish", "closed", "open", "", "29", "", "", "2014-11-25 02:04:48", "2014-11-25 02:04:48", "", "0", "http://sightseer.ca/arcengineering/?p=29", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2014-11-25 02:04:48", "2014-11-25 02:04:48", " ", "", "", "publish", "closed", "open", "", "30", "", "", "2014-11-25 02:04:48", "2014-11-25 02:04:48", "", "0", "http://sightseer.ca/arcengineering/?p=30", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2014-11-25 02:04:48", "2014-11-25 02:04:48", " ", "", "", "publish", "closed", "open", "", "31", "", "", "2014-11-25 02:04:48", "2014-11-25 02:04:48", "", "0", "http://sightseer.ca/arcengineering/?p=31", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "avia_logo", "", "draft", "closed", "closed", "", "", "", "", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?post_type=avia_framework_post&p=32", "0", "avia_framework_post", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "avia_favicon", "", "draft", "closed", "closed", "", "", "", "", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?post_type=avia_framework_post&p=33", "0", "avia_framework_post", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "avia_custom_background_image", "", "draft", "closed", "closed", "", "", "", "", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?post_type=avia_framework_post&p=34", "0", "avia_framework_post", "", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "avia_transparency_logo", "", "draft", "closed", "closed", "", "", "", "", "2014-11-25 02:27:09", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?post_type=avia_framework_post&p=35", "0", "avia_framework_post", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2014-11-25 02:46:29", "2014-11-25 02:46:29", "", "ARC_Logo-small", "", "inherit", "closed", "open", "", "arc_logo-small", "", "", "2014-11-25 02:53:50", "2014-11-25 02:53:50", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC_Logo-small.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2014-11-25 02:51:28", "0000-00-00 00:00:00", "", "avia_template_builder_snippets", "", "draft", "closed", "closed", "", "", "", "", "2014-11-25 02:51:28", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?post_type=avia_framework_post&p=37", "0", "avia_framework_post", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2014-11-25 02:52:04", "2014-11-25 02:52:04", "[av_content_slider heading=\'\' columns=\'1\' animation=\'slide\' navigation=\'arrows\' autoplay=\'false\' interval=\'5\' font_color=\'\' color=\'\']\r\n[av_content_slide title=\'Slide 1\' tags=\'\']\r\n[av_content_slide title=\'Slide 2\' tags=\'\']\r\n[/av_content_slider]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_content_slider heading=\'\' columns=\'1\' animation=\'slide\' navigation=\'arrows\' autoplay=\'false\' interval=\'5\' font_color=\'\' color=\'\']\r\n[av_content_slide title=\'Slide 1\' tags=\'\']\r\n[av_content_slide title=\'Slide 2\' tags=\'\']\r\n[/av_content_slider]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2014-11-25 02:52:04", "2014-11-25 02:52:04", "", "2", "http://sightseer.ca/arcengineering/?p=38", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2014-11-25 02:54:05", "2014-11-25 02:54:05", "[av_content_slider heading=\'\' columns=\'1\' animation=\'fade\' navigation=\'arrows\' autoplay=\'false\' interval=\'5\' font_color=\'\' color=\'\']\r\n[av_content_slide title=\'Slide 1\' link=\'\' linktarget=\'\']\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC_Logo-small.png\"><img class=\"alignnone size-full wp-image-36\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC_Logo-small.png\" alt=\"ARC_Logo-small\" width=\"150\" height=\"74\" /></a>Add image here\r\n[/av_content_slide]\r\n[av_content_slide title=\'Slide 2\' tags=\'\' link=\'\' linktarget=\'\']\r\nSlide Content goes here\r\n[/av_content_slide]\r\n[/av_content_slider]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2014-11-25 02:54:05", "2014-11-25 02:54:05", "", "2", "http://sightseer.ca/arcengineering/?p=39", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2014-11-25 02:54:47", "2014-11-25 02:54:47", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'false\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2014-11-25 02:54:47", "2014-11-25 02:54:47", "", "2", "http://sightseer.ca/arcengineering/?p=40", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2014-11-25 02:59:24", "2014-11-25 02:59:24", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'false\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'41\'][/av_slide_full]\r\n[av_slide_full id=\'42\'][/av_slide_full]\r\n[av_slide_full id=\'43\'][/av_slide_full]\r\n[av_slide_full id=\'44\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2014-11-25 02:59:24", "2014-11-25 02:59:24", "", "2", "http://sightseer.ca/arcengineering/?p=45", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2014-11-25 03:01:08", "2014-11-25 03:01:08", "", "News", "", "publish", "closed", "open", "", "news", "", "", "2014-11-25 03:01:08", "2014-11-25 03:01:08", "", "0", "http://sightseer.ca/arcengineering/?page_id=46", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2014-11-25 03:01:08", "2014-11-25 03:01:08", "", "News", "", "inherit", "closed", "open", "", "46-revision-v1", "", "", "2014-11-25 03:01:08", "2014-11-25 03:01:08", "", "46", "http://sightseer.ca/arcengineering/?p=47", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2015-02-11 02:00:23", "2015-02-11 02:00:23", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\n[av_slide_full id=\'141\'][/av_slide_full]\n[av_slide_full id=\'139\'][/av_slide_full]\n[av_slide_full id=\'138\'][/av_slide_full]\n[av_slide_full id=\'137\'][/av_slide_full]\n[/av_slideshow_full]\n\n[av_one_half first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h3>Services</h3>\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\n\nWe provide services for new and renovated projects including:\n<ul>\n	<li>Commercial Projects</li>\n	<li>Office Buildings</li>\n	<li>Building conversions</li>\n	<li>Institutional projects</li>\n	<li>Shopping centres</li>\n	<li>Retrofits</li>\n	<li>HVAC, Plumbing, and Fire Protection</li>\n	<li>LEED Services</li>\n	<li>Energy Modeling</li>\n</ul>\n<h5>Report and Studies.</h5>\n<ul>\n	<li>Building Condition Reports</li>\n	<li>Feasibility Studies</li>\n	<li>Energy Analysis</li>\n</ul>\n[/av_textblock]\n[/av_one_half]\n\n[av_one_half]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h3>Partnerships</h3>\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\n\nElectrical\n\nArchitectural\n\nStructural\n\nCivil\n\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\n[/av_textblock]\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-autosave-v1", "", "", "2015-02-11 02:00:23", "2015-02-11 02:00:23", "", "8", "http://sightseer.ca/arcengineering/?p=48", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2014-11-25 03:04:21", "2014-11-25 03:04:21", "[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h2>Services</h2>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h2>Partnerships</h2>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2014-11-25 03:04:21", "2014-11-25 03:04:21", "", "8", "http://sightseer.ca/arcengineering/?p=49", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2014-11-25 03:08:36", "2014-11-25 03:08:36", "[av_one_half first]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_half][av_one_half]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_half][av_one_third first]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_third][av_one_third]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_third][av_one_third]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_third][av_textblock size=\'\' font_color=\'\' color=\'\']\n<h1>History</h1>\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\nFollowing the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\n\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\n\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\n\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\n\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\n\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\n\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\n\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\n\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\n\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\n\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\n\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\n<h5>Today</h5>\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\n\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\n[/av_textblock]\n\n[av_one_half first][/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-autosave-v1", "", "", "2014-11-25 03:08:36", "2014-11-25 03:08:36", "", "5", "http://sightseer.ca/arcengineering/?p=50", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2014-11-25 03:10:33", "2014-11-25 03:10:33", "[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nAdd Slider\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\nFollowing the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2014-11-25 03:10:33", "2014-11-25 03:10:33", "", "5", "http://sightseer.ca/arcengineering/?p=51", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2014-11-25 03:11:24", "2014-11-25 03:11:24", "[av_one_half first]\r\n\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'false\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'44\'][/av_slide]\r\n[av_slide id=\'43\'][/av_slide]\r\n[av_slide id=\'42\'][/av_slide]\r\n[av_slide id=\'41\'][/av_slide]\r\n[/av_slideshow]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\nFollowing the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2014-11-25 03:11:24", "2014-11-25 03:11:24", "", "5", "http://sightseer.ca/arcengineering/?p=52", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2014-11-25 03:11:52", "2014-11-25 03:11:52", "[av_one_half first]\r\n\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'44\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'43\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'42\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'41\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[/av_slideshow]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\nFollowing the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2014-11-25 03:11:52", "2014-11-25 03:11:52", "", "5", "http://sightseer.ca/arcengineering/?p=53", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2014-11-25 03:12:27", "2014-11-25 03:12:27", "[av_one_half first]\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'44\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'43\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'42\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'41\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[/av_slideshow]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\nFollowing the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2014-11-25 03:12:27", "2014-11-25 03:12:27", "", "5", "http://sightseer.ca/arcengineering/?p=54", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2014-11-25 03:13:40", "2014-11-25 03:13:40", "[av_one_half first]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_half][av_one_half]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nClick here to add your own text\n[/av_textblock]\n\n[/av_one_half][av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Address</h5>\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\n\nPhone: (905) 643-8530 Fax: (905) 643-8510\n\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\n\n<!-- Google Map of location-->\n<iframe src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\n\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\">View Larger Map</a></small>\n\n<!-- Google Map of location-->\n<h5>Contact our Staff</h5>\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\n\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\n\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\n\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\n\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\n\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\n\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\n\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\n\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\n\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\n\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\n[/av_textblock]", "Contact Us", "", "inherit", "closed", "open", "", "21-autosave-v1", "", "", "2014-11-25 03:13:40", "2014-11-25 03:13:40", "", "21", "http://sightseer.ca/arcengineering/?p=55", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2014-11-25 03:14:41", "2014-11-25 03:14:41", "[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Address</h5>\r\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\r\n\r\nPhone: (905) 643-8530 Fax: (905) 643-8510\r\n\r\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<!-- Google Map of location-->\r\n<iframe src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\r\n\r\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Address</h5>\r\n1100 South Service Rd., Suite #417, Stoney Creek ON L8E 0C5\r\n\r\nPhone: (905) 643-8530 Fax: (905) 643-8510\r\n\r\nEmail: <a href=\"mailto:contact@arcengineering.ca\">Click Here</a>\r\n\r\n<!-- Google Map of location-->\r\n<iframe src=\"https://maps.google.com/maps?f=q&amp;source=s_q&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914&amp;output=embed\" width=\"375\" height=\"290\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"yes\"></iframe>\r\n\r\n<small><a style=\"color: #0000ff; text-align: left;\" href=\"https://maps.google.com/maps?f=q&amp;source=embed&amp;hl=en&amp;geocode=&amp;q=1100+South+Service+Road,+Hamilton,+ON,+Canada&amp;aq=1&amp;oq=1100+SOUTH+SER&amp;sll=43.272523,-79.482372&amp;sspn=0.779922,1.783905&amp;t=w&amp;ie=UTF8&amp;hq=&amp;hnear=1100+S+Service+Rd,+Hamilton,+Hamilton+Division,+Ontario+L8E+5E3,+Canada&amp;z=14&amp;ll=43.222301,-79.659914\">View Larger Map</a></small>\r\n\r\n<!-- Google Map of location-->\r\n<h5>Contact our Staff</h5>\r\n<a href=\"mailto:arebek@arcengineering.ca\">Art Rebek, P.Eng, LEED AP, President</a>\r\n\r\n<a href=\"mailto:brobinson@arcengineering.ca\">Brad Robinson, C.Eng., P.Eng, LEED AP BD+C, Manager of Projects</a>\r\n\r\n<a href=\"mailto:dtaylor@arcengineering.ca\">David Taylor, B.A., B.Sc., Senior Designer</a>\r\n\r\n<a href=\"mailto:hroberts@arcengineering.ca\">Howard Roberts, M.Eng., MBA., P.Eng., Project Manager</a>\r\n\r\n<a href=\"mailto:dmcniven@arcengineering.ca\">Dan McNiven, P.Eng., Project Manager </a>\r\n\r\n<a href=\"mailto:jrocha@arcengineering.ca\">Joe Rocha, Designer</a>\r\n\r\n<a href=\"mailto:jcox@arcengineering.ca\">Joshua Cox, E.I.T., CAD Designer</a>\r\n\r\n<a href=\"mailto:aghadi@arcengineering.ca\">Al Ghadi, CAD Designer</a>\r\n\r\n<a href=\"mailto:jwalker@arcengineering.ca\">Joseph Walker, Field Representative</a>\r\n\r\n<a href=\"mailto:trebek@arcengineering.ca\">Terri Rebek, Manager of Accounting</a>\r\n\r\n<a href=\"mailto:ksonephommasith@arcengineering.ca\">Kay Sonephommasith, Administrative Assistant</a>\r\n[/av_textblock]", "Contact Us", "", "inherit", "closed", "open", "", "21-revision-v1", "", "", "2014-11-25 03:14:41", "2014-11-25 03:14:41", "", "21", "http://sightseer.ca/arcengineering/?p=56", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2014-11-25 03:20:56", "2014-11-25 03:20:56", "[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\nPathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\nWe are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2014-11-25 03:20:56", "2014-11-25 03:20:56", "", "10", "http://sightseer.ca/arcengineering/?p=57", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2014-11-25 03:23:00", "2014-11-25 03:23:00", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'44\'][/av_slide_full]\r\n[av_slide_full id=\'43\'][/av_slide_full]\r\n[av_slide_full id=\'42\'][/av_slide_full]\r\n[av_slide_full id=\'41\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h2>Services</h2>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h2>Partnerships</h2>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2014-11-25 03:23:00", "2014-11-25 03:23:00", "", "8", "http://sightseer.ca/arcengineering/?p=58", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2014-11-25 03:24:04", "2014-11-25 03:24:04", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'41\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'42\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'43\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'44\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2014-11-25 03:24:04", "2014-11-25 03:24:04", "", "2", "http://sightseer.ca/arcengineering/?p=59", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2014-11-25 03:27:35", "2014-11-25 03:27:35", "", "51b3cb4f1e43a18904", "", "inherit", "closed", "open", "", "51b3cb4f1e43a18904", "", "", "2014-11-25 03:27:35", "2014-11-25 03:27:35", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/51b3cb4f1e43a18904.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("61", "1", "2014-11-25 03:27:37", "2014-11-25 03:27:37", "", "1022058_59074159", "", "inherit", "closed", "open", "", "1022058_59074159", "", "", "2014-11-25 03:27:37", "2014-11-25 03:27:37", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/1022058_59074159.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2014-11-25 03:27:40", "2014-11-25 03:27:40", "", "1072216_52298388", "", "inherit", "closed", "open", "", "1072216_52298388", "", "", "2014-11-25 03:27:40", "2014-11-25 03:27:40", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/1072216_52298388.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("63", "1", "2014-11-25 03:27:42", "2014-11-25 03:27:42", "", "1169213_21767800", "", "inherit", "closed", "open", "", "1169213_21767800", "", "", "2014-11-25 03:27:42", "2014-11-25 03:27:42", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/1169213_21767800.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2014-11-25 03:28:14", "2014-11-25 03:28:14", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\'][/av_slide_full]\r\n[av_slide_full id=\'62\'][/av_slide_full]\r\n[av_slide_full id=\'61\'][/av_slide_full]\r\n[av_slide_full id=\'60\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<span class=\"bold\">We specialize in finding the right solution to suit our</span> clients needs, whether it be a cost effective design for a new project, or improving an existing design. We provide solutions for Building Services Design - HVAC, plumbing and fire protection systems to provide a comfortable, healthy and safe environment.\r\n\r\n<span class=\"bold\">Our philosophy is simple - provide the best service possible</span> to meet our clients goals and budget. We will work through any engineering problem to find an effective, cost efficient solution.\r\n\r\n<span class=\"bold\">Sustainable design and energy efficiency are at the core of</span> our design approach for any project. This leads to greater long term savings in operating costs for the Owner, and a more environmentally responsible approach to Building Design.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2014-11-25 03:28:14", "2014-11-25 03:28:14", "", "2", "http://sightseer.ca/arcengineering/?p=64", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2014-11-25 03:28:37", "2014-11-25 03:28:37", "[av_one_half first]\r\n\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\'][/av_slide]\r\n[av_slide id=\'62\'][/av_slide]\r\n[av_slide id=\'61\'][/av_slide]\r\n[av_slide id=\'60\'][/av_slide]\r\n[/av_slideshow]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\nFollowing the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2014-11-25 03:28:37", "2014-11-25 03:28:37", "", "5", "http://sightseer.ca/arcengineering/?p=65", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2014-11-25 03:29:43", "2014-11-25 03:29:43", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\'][/av_slide_full]\r\n[av_slide_full id=\'62\'][/av_slide_full]\r\n[av_slide_full id=\'61\'][/av_slide_full]\r\n[av_slide_full id=\'60\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h2>Services</h2>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h2>Partnerships</h2>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2014-11-25 03:29:43", "2014-11-25 03:29:43", "", "8", "http://sightseer.ca/arcengineering/?p=66", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2014-11-25 03:31:14", "2014-11-25 03:31:14", "Lost in the shuffle during our move was the announcement of some new staff. Howard Roberts, M.Eng, MBA, P.Eng and Dan McNiven, P.Eng have joined our staff in the roles of Project Managers. Both have extensive experience in the Consulting industry, and bring years of combined knowledge and expertise to our team. Welcome aboard!", "March 30, 2013", "", "inherit", "closed", "open", "", "1-revision-v1", "", "", "2014-11-25 03:31:14", "2014-11-25 03:31:14", "", "1", "http://sightseer.ca/arcengineering/?p=67", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2012-11-05 03:31:39", "2012-11-05 03:31:39", "<p class=\"MyClass1\">The renovations for our new office space are complete. We look forward to welcoming our friends and clients to an open house once we are settled in. Please note our address and phone number changes:</p>\r\n<p class=\"MyClass1\">1100 South Service Road, Suite 417</p>\r\n<p class=\"MyClass1\">Stoney Creek, ON L8E 0C5</p>\r\n<p class=\"MyClass1\"><span class=\"Phone\">Phone:</span> (905) 643-8530<span class=\"Phone\"> Fax: </span>(905) 643-8510</p>", "November 5, 2012", "", "publish", "closed", "open", "", "november-5-2012", "", "", "2014-11-25 03:37:44", "2014-11-25 03:37:44", "", "0", "http://sightseer.ca/arcengineering/?p=68", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2014-11-25 03:31:39", "2014-11-25 03:31:39", "<p class=\"MyClass1\">The renovations for our new office space are complete. We look forward to welcoming our friends and clients to an open house once we are settled in. Please note our address and phone number changes:</p>\r\n<p class=\"MyClass1\">1100 South Service Road, Suite 417</p>\r\n<p class=\"MyClass1\">Stoney Creek, ON L8E 0C5</p>\r\n<p class=\"MyClass1\"><span class=\"Phone\">Phone:</span> (905) 643-8530<span class=\"Phone\"> Fax: </span>(905) 643-8510</p>", "November 5, 2012", "", "inherit", "closed", "open", "", "68-revision-v1", "", "", "2014-11-25 03:31:39", "2014-11-25 03:31:39", "", "68", "http://sightseer.ca/arcengineering/?p=69", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2012-10-08 03:31:57", "2012-10-08 03:31:57", "The renovations for our new office space are nearing completion, and we look forward to moving in! We hope to be in by the 1st week of November. Check back for more updates.", "October 8, 2012", "", "publish", "closed", "open", "", "october-8-2012", "", "", "2014-11-25 03:38:12", "2014-11-25 03:38:12", "", "0", "http://sightseer.ca/arcengineering/?p=70", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2014-11-25 03:31:57", "2014-11-25 03:31:57", "The renovations for our new office space are nearing completion, and we look forward to moving in! We hope to be in by the 1st week of November. Check back for more updates.", "October 8, 2012", "", "inherit", "closed", "open", "", "70-revision-v1", "", "", "2014-11-25 03:31:57", "2014-11-25 03:31:57", "", "70", "http://sightseer.ca/arcengineering/?p=71", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("75", "2", "2015-01-07 16:57:15", "2015-01-07 16:57:15", "", "arc engineering logo direction", "", "inherit", "closed", "open", "", "arc-engineering-logo-direction", "", "", "2015-01-07 16:57:15", "2015-01-07 16:57:15", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/arc-engineering-logo-direction.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("77", "2", "2015-01-07 17:33:56", "2015-01-07 17:33:56", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\'][/av_slide_full]\r\n[av_slide_full id=\'62\'][/av_slide_full]\r\n[av_slide_full id=\'61\'][/av_slide_full]\r\n[av_slide_full id=\'60\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence.  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-07 17:33:56", "2015-01-07 17:33:56", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("78", "2", "2015-01-07 17:36:05", "2015-01-07 17:36:05", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\'][/av_slide_full]\r\n[av_slide_full id=\'62\'][/av_slide_full]\r\n[av_slide_full id=\'61\'][/av_slide_full]\r\n[av_slide_full id=\'60\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-07 17:36:05", "2015-01-07 17:36:05", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("79", "2", "2015-01-09 14:43:54", "2015-01-09 14:43:54", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'test caption\' custom_title_size=\'20\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 14:43:54", "2015-01-09 14:43:54", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("80", "2", "2015-01-09 14:46:52", "2015-01-09 14:46:52", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'test caption\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\']\r\nmore caption\r\n[/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 14:46:52", "2015-01-09 14:46:52", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("81", "2", "2015-01-09 14:47:40", "2015-01-09 14:47:40", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'test caption\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\']\r\nmore caption\r\n[/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 14:47:40", "2015-01-09 14:47:40", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("83", "2", "2015-01-09 14:50:16", "2015-01-09 14:50:16", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'test caption\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\']\r\nmore caption\r\n[/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<strong>ARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.</strong>\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 14:50:16", "2015-01-09 14:50:16", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("85", "2", "2015-01-09 14:50:49", "2015-01-09 14:50:49", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'test caption\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\']\r\nmore caption\r\n[/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<strong>ARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.</strong>\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\n<strong>We do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.</strong>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span><strong>\r\n[/av_textblock]</strong>", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 14:50:49", "2015-01-09 14:50:49", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("87", "2", "2015-01-09 14:51:59", "2015-01-09 14:51:59", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 14:51:59", "2015-01-09 14:51:59", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("89", "2", "2015-01-09 15:12:44", "2015-01-09 15:12:44", "", "art", "", "inherit", "closed", "open", "", "art", "", "", "2015-01-09 15:12:44", "2015-01-09 15:12:44", "", "5", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("90", "2", "2015-01-09 15:12:57", "2015-01-09 15:12:57", "", "brad", "", "inherit", "closed", "open", "", "brad", "", "", "2015-01-09 15:12:57", "2015-01-09 15:12:57", "", "5", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("91", "2", "2015-02-17 16:39:08", "2015-02-17 16:39:08", "[av_one_half first]\n\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\n[av_slide id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\n[av_slide id=\'62\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\n[/av_slideshow]\n\n[/av_one_half][av_one_half]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\n\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\n[/av_textblock]\n[/av_one_half]\n\n[av_one_half first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\"  wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"150\" height=\"150\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\n\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\n\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\n\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\n\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\n\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\n\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\n[/av_textblock]\n[/av_one_half]\n\n[av_one_half]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\"  wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"150\" height=\"150\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\n\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\n\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\n\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\n\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\n\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\n[/av_textblock]\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-autosave-v1", "", "", "2015-02-17 16:39:08", "2015-02-17 16:39:08", "", "5", "http://sightseer.ca/arcengineering/5-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("92", "2", "2015-01-09 15:14:11", "2015-01-09 15:14:11", "[av_one_half first]\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\'][/av_slide]\r\n[av_slide id=\'62\'][/av_slide]\r\n[av_slide id=\'61\'][/av_slide]\r\n[av_slide id=\'60\'][/av_slide]\r\n[/av_slideshow]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\" size-full wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"200\" height=\"200\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\nBrad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2015-01-09 15:14:11", "2015-01-09 15:14:11", "", "5", "http://sightseer.ca/arcengineering/5-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("93", "2", "2015-01-09 15:14:57", "2015-01-09 15:14:57", "[av_one_half first]\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\'][/av_slide]\r\n[av_slide id=\'62\'][/av_slide]\r\n[av_slide id=\'61\'][/av_slide]\r\n[av_slide id=\'60\'][/av_slide]\r\n[/av_slideshow]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\" size-full wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"200\" height=\"200\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\" size-full wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"200\" height=\"200\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2015-01-09 15:14:57", "2015-01-09 15:14:57", "", "5", "http://sightseer.ca/arcengineering/5-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("94", "2", "2015-01-09 15:18:31", "2015-01-09 15:18:31", "", "pathstone", "", "inherit", "closed", "open", "", "pathstone", "", "", "2015-01-09 15:18:31", "2015-01-09 15:18:31", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("95", "2", "2015-01-09 15:18:48", "2015-01-09 15:18:48", "", "district school bd niagara", "", "inherit", "closed", "open", "", "district-school-bd-niagara", "", "", "2015-01-09 15:18:48", "2015-01-09 15:18:48", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("96", "2", "2015-01-09 15:19:02", "2015-01-09 15:19:02", "", "stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table", "", "inherit", "closed", "open", "", "stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table", "", "", "2015-01-09 15:19:02", "2015-01-09 15:19:02", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("97", "2", "2015-01-09 16:43:01", "2015-01-09 16:43:01", "[av_one_full first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nThe following brochures give an overview of some sector specific projects we have been working on:\n\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\n\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\n[/av_textblock]\n[/av_one_full]\n\n[av_one_half first]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\n<h5></h5>\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\n<h5></h5>\n<h5></h5>\n<h5></h5>\n<h5></h5>\n<h5></h5>\n<h5></h5>\n<h5>Wingbury Properties, Dundas, Ontario</h5>\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\n<h5>Niagara College, St. Catharines, Ontario</h5>\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\n<h5>Markham District Energy, Markham, Ontario</h5>\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\n<h5>Actlabs, Ancaster, Ontario</h5>\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\n<h5>Brock University, St .Catharines, Ontario</h5>\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\n<h5>McMaster University, Hamilton, Ontario</h5>\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\n<h5>Alton Village, Burlington, Ontario</h5>\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\n[/av_textblock]\n\n[/av_one_half][av_one_half]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\n<h5></h5>\n<h5></h5>\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"129\" height=\"86\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\n<h5></h5>\n<h5></h5>\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"134\" height=\"117\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\n<h5></h5>\n<h5></h5>\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\n\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\nBoiler venting modifications.\n<h5>Ridley College, St. Catharines, Ontario</h5>\nChapel Heating Retrofit\n\nAquatic Centre HVAC Renovation\n\nGymnasium Weight Training Area Retrofit\n\nScience Room area Retrofit\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\nBoiler Burner Retrofit\n\nDomestic Hot Water Plant Retrofit\n<h5>Pearson Airport. Toronto, Ontario</h5>\nGTAA Fueling System\n<h5>Project Management - JNE Consulting Engineering</h5>\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\n\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\n\nSubconsulting for ISO 9000 Certification Planning and Implementation\n\nSubconsulting on Stelco By-Products Misa Project\n[/av_textblock]\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-autosave-v1", "", "", "2015-01-09 16:43:01", "2015-01-09 16:43:01", "", "10", "http://sightseer.ca/arcengineering/10-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("98", "2", "2015-01-09 15:20:06", "2015-01-09 15:20:06", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\" size-full wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"259\" height=\"194\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\" size-full wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"251\" height=\"201\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 15:20:06", "2015-01-09 15:20:06", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("99", "2", "2015-01-09 15:21:17", "2015-01-09 15:21:17", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 15:21:17", "2015-01-09 15:21:17", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("100", "2", "2015-01-09 15:24:17", "2015-01-09 15:24:17", "", "niagara housing", "", "inherit", "closed", "open", "", "niagara-housing", "", "", "2015-01-09 15:25:02", "2015-01-09 15:25:02", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("101", "2", "2015-01-09 15:24:26", "2015-01-09 15:24:26", "", "gryphin", "", "inherit", "closed", "open", "", "gryphin", "", "", "2015-01-09 15:25:17", "2015-01-09 15:25:17", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("102", "2", "2015-01-09 15:27:03", "2015-01-09 15:27:03", "", "winery", "", "inherit", "closed", "open", "", "winery", "", "", "2015-01-09 15:27:03", "2015-01-09 15:27:03", "", "10", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("103", "2", "2015-01-09 15:29:38", "2015-01-09 15:29:38", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"166\" height=\"110\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 15:29:38", "2015-01-09 15:29:38", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("104", "2", "2015-01-09 15:30:15", "2015-01-09 15:30:15", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"166\" height=\"110\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 15:30:15", "2015-01-09 15:30:15", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("105", "2", "2015-01-09 15:30:55", "2015-01-09 15:30:55", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"166\" height=\"110\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 15:30:55", "2015-01-09 15:30:55", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("106", "2", "2015-01-09 15:34:17", "2015-01-09 15:34:17", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 15:34:17", "2015-01-09 15:34:17", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("108", "2", "2015-01-09 15:36:02", "2015-01-09 15:36:02", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\'][/av_slide_full]\r\n[av_slide_full id=\'62\'][/av_slide_full]\r\n[av_slide_full id=\'61\'][/av_slide_full]\r\n[av_slide_full id=\'60\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h1>Services</h1>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h1>Partnerships</h1>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2015-01-09 15:36:02", "2015-01-09 15:36:02", "", "8", "http://sightseer.ca/arcengineering/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("109", "2", "2015-01-09 15:36:41", "2015-01-09 15:36:41", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\'][/av_slide_full]\r\n[av_slide_full id=\'62\'][/av_slide_full]\r\n[av_slide_full id=\'61\'][/av_slide_full]\r\n[av_slide_full id=\'60\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Services</h3>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Partnerships</h3>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2015-01-09 15:36:41", "2015-01-09 15:36:41", "", "8", "http://sightseer.ca/arcengineering/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("110", "2", "2015-01-09 15:37:28", "2015-01-09 15:37:28", "<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table.jpg\"><img class=\"  wp-image-96 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table-300x242.jpg\" alt=\"stock-photo-38043002-group-of-construction-site-workers-on-a-conference-table\" width=\"226\" height=\"182\" /></a>Since opening our doors in 2010, we have expanded our client base and are currently looking for skilled, accomplished and motivated professional engineers, designers, and technologists to join our team.\r\n\r\nWe have the following positions open: <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Designer.pdf\">Mechanical Designer</a> and <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/Technologist.pdf\">Mechanical Technologist</a>. Please apply in person at:\r\n1100 South Service Rd., Suite #417\r\nStoney Creek, ON L8E 0C5\r\n\r\nPlease click <a href=\"mailto:contact@arcengineering.ca\">here</a> to submit your resume or for any employment queries.", "Careers", "", "inherit", "closed", "open", "", "24-revision-v1", "", "", "2015-01-09 15:37:28", "2015-01-09 15:37:28", "", "24", "http://sightseer.ca/arcengineering/24-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("111", "2", "2015-01-09 16:04:39", "2015-01-09 16:04:39", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:04:39", "2015-01-09 16:04:39", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("112", "2", "2015-01-09 16:06:03", "2015-01-09 16:06:03", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"182\" height=\"121\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:06:03", "2015-01-09 16:06:03", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("113", "2", "2015-01-09 16:06:54", "2015-01-09 16:06:54", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"129\" height=\"86\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"140\" height=\"122\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:06:54", "2015-01-09 16:06:54", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("114", "2", "2015-01-09 16:07:39", "2015-01-09 16:07:39", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"129\" height=\"86\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"123\" height=\"107\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:07:39", "2015-01-09 16:07:39", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("115", "2", "2015-01-09 16:08:23", "2015-01-09 16:08:23", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"129\" height=\"86\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"134\" height=\"117\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:08:23", "2015-01-09 16:08:23", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("116", "2", "2015-01-09 16:09:12", "2015-01-09 16:09:12", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"129\" height=\"86\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"134\" height=\"117\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:09:12", "2015-01-09 16:09:12", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("117", "2", "2015-01-09 16:15:38", "2015-01-09 16:15:38", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"210\" height=\"157\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"181\" height=\"145\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\" size-full wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"137\" height=\"94\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"129\" height=\"86\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"134\" height=\"117\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:15:38", "2015-01-09 16:15:38", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("119", "2", "2015-01-09 16:34:05", "2015-01-09 16:34:05", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<strong>ARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.</strong>\r\n\r\n<strong>Our Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.</strong>\r\n\r\n<strong>We do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.</strong>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 16:34:05", "2015-01-09 16:34:05", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("120", "2", "2015-01-09 16:34:55", "2015-01-09 16:34:55", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 16:34:55", "2015-01-09 16:34:55", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("122", "2", "2015-01-09 16:36:44", "2015-01-09 16:36:44", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full slide_type=\'image\' id=\'62\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' title=\'\' custom_title_size=\'20\' custom_content_size=\'23\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'lightbox\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'manually,http://\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'manually,http://\' link_target2=\'\' font_color=\'custom\' custom_title=\'#686868\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'61\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'60\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-01-09 16:36:44", "2015-01-09 16:36:44", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("123", "2", "2015-01-09 16:41:10", "2015-01-09 16:41:10", "[av_one_half first]\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\'][/av_slide]\r\n[av_slide id=\'62\'][/av_slide]\r\n[av_slide id=\'61\'][/av_slide]\r\n[av_slide id=\'60\'][/av_slide]\r\n[/av_slideshow]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\"  wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"150\" height=\"150\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\"  wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"150\" height=\"150\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2015-01-09 16:41:10", "2015-01-09 16:41:10", "", "5", "http://sightseer.ca/arcengineering/5-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("124", "2", "2015-01-09 16:43:22", "2015-01-09 16:43:22", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignnone\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:43:22", "2015-01-09 16:43:22", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("125", "2", "2015-01-09 16:44:29", "2015-01-09 16:44:29", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:44:29", "2015-01-09 16:44:29", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("126", "2", "2015-01-09 16:45:03", "2015-01-09 16:45:03", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:45:03", "2015-01-09 16:45:03", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("127", "2", "2015-01-09 16:46:10", "2015-01-09 16:46:10", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant.\r\n\r\nSolar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-01-09 16:46:10", "2015-01-09 16:46:10", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("129", "1", "2015-02-11 01:45:21", "2015-02-11 01:45:21", "", "arclogo", "", "inherit", "closed", "open", "", "arclogo", "", "", "2015-02-11 01:45:21", "2015-02-11 01:45:21", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/02/arclogo.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2015-02-11 01:49:46", "2015-02-11 01:49:46", "[av_one_half first]\r\n\r\n[av_image src=\'http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\' attachment=\'94\' attachment_size=\'full\' align=\'center\' animation=\'no-animation\' link=\'\' target=\'\' styling=\'\' caption=\'\' font_size=\'\' appearance=\'\'][/av_image]\r\n\r\n[/av_one_half][av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nPathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Pathstone Mental Health, Thorold, Ontario", "", "publish", "closed", "open", "", "pathstone-mental-health-thorold-ontario", "", "", "2015-02-11 01:56:23", "2015-02-11 01:56:23", "", "0", "http://sightseer.ca/arcengineering/?post_type=portfolio&#038;p=130", "0", "portfolio", "", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2015-02-11 01:58:29", "2015-02-11 01:58:29", "", "image1", "", "inherit", "closed", "open", "", "image1", "", "", "2015-02-11 01:58:29", "2015-02-11 01:58:29", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("135", "1", "2015-02-11 01:58:30", "2015-02-11 01:58:30", "", "image2", "", "inherit", "closed", "open", "", "image2", "", "", "2015-02-11 01:58:30", "2015-02-11 01:58:30", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2015-02-11 01:58:31", "2015-02-11 01:58:31", "", "image3", "", "inherit", "closed", "open", "", "image3", "", "", "2015-02-11 01:58:31", "2015-02-11 01:58:31", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("137", "1", "2015-02-11 01:58:32", "2015-02-11 01:58:32", "", "image4", "", "inherit", "closed", "open", "", "image4", "", "", "2015-02-11 01:58:32", "2015-02-11 01:58:32", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("138", "1", "2015-02-11 01:58:33", "2015-02-11 01:58:33", "", "image5", "", "inherit", "closed", "open", "", "image5", "", "", "2015-02-11 01:58:33", "2015-02-11 01:58:33", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("139", "1", "2015-02-11 01:58:34", "2015-02-11 01:58:34", "", "image6", "", "inherit", "closed", "open", "", "image6", "", "", "2015-02-11 01:58:34", "2015-02-11 01:58:34", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("140", "1", "2015-02-11 01:58:35", "2015-02-11 01:58:35", "", "image7", "", "inherit", "closed", "open", "", "image7", "", "", "2015-02-11 01:58:35", "2015-02-11 01:58:35", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("141", "1", "2015-02-11 01:58:36", "2015-02-11 01:58:36", "", "image8", "", "inherit", "closed", "open", "", "image8", "", "", "2015-02-11 01:58:36", "2015-02-11 01:58:36", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/image8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("142", "1", "2015-02-11 01:59:08", "2015-02-11 01:59:08", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\n[av_slide_full id=\'134\'][/av_slide_full]\n[av_slide_full id=\'135\'][/av_slide_full]\n[av_slide_full id=\'140\'][/av_slide_full]\n[/av_slideshow_full]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\n\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\n\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\n\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\n\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\n[/av_textblock]\n\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "inherit", "closed", "open", "", "2-autosave-v1", "", "", "2015-02-11 01:59:08", "2015-02-11 01:59:08", "", "2", "http://sightseer.ca/arcengineering/2-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("143", "1", "2015-02-11 01:59:10", "2015-02-11 01:59:10", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'134\'][/av_slide_full]\r\n[av_slide_full id=\'135\'][/av_slide_full]\r\n[av_slide_full id=\'140\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-02-11 01:59:10", "2015-02-11 01:59:10", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("144", "1", "2015-02-11 02:00:30", "2015-02-11 02:00:30", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'141\'][/av_slide_full]\r\n[av_slide_full id=\'139\'][/av_slide_full]\r\n[av_slide_full id=\'138\'][/av_slide_full]\r\n[av_slide_full id=\'137\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Services</h3>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Partnerships</h3>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2015-02-11 02:00:30", "2015-02-11 02:00:30", "", "8", "http://sightseer.ca/arcengineering/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2015-02-11 02:00:49", "2015-02-11 02:00:49", "", "arclogo", "", "inherit", "closed", "open", "", "arclogo-2", "", "", "2015-02-11 02:00:49", "2015-02-11 02:00:49", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/02/arclogo1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("146", "1", "2015-02-11 02:01:38", "2015-02-11 02:01:38", "", "arclogo", "", "inherit", "closed", "open", "", "arclogo-3", "", "", "2015-02-11 02:01:38", "2015-02-11 02:01:38", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/02/arclogo2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("147", "1", "2015-02-11 02:05:55", "2015-02-11 02:05:55", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:05:55", "2015-02-11 02:05:55", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("148", "1", "2015-02-11 02:08:36", "2015-02-11 02:08:36", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading heading=\'Commercial\' tag=\'h3\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_heading heading=\'Industrial\' tag=\'h3\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_heading heading=\'Institutional\' tag=\'h3\' style=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'10\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:08:36", "2015-02-11 02:08:36", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("149", "1", "2015-02-11 02:10:22", "2015-02-11 02:10:22", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Commercial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_magazine link=\'portfolio_entries,4\' items=\'5\' offset=\'0\' tabs=\'aviaTBtabs\' thumbnails=\'aviaTBthumbnails\' heading=\'\' heading_link=\'manually,http://\' heading_color=\'theme-color\' heading_custom_color=\'#ffffff\' first_big_pos=\'top\']\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Industrial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Institutional\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:10:22", "2015-02-11 02:10:22", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("150", "1", "2015-02-11 02:13:03", "2015-02-11 02:13:03", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Commercial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_magazine link=\'portfolio_entries,4,3,5\' items=\'5\' offset=\'0\' tabs=\'aviaTBtabs\' thumbnails=\'aviaTBthumbnails\' heading=\'\' heading_link=\'manually,http://\' heading_color=\'theme-color\' heading_custom_color=\'#ffffff\' first_big_pos=\'top\']\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Industrial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Institutional\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:13:03", "2015-02-11 02:13:03", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("151", "1", "2015-02-11 02:13:37", "2015-02-11 02:13:37", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Commercial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Industrial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Institutional\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Niagara Regional Housing, Welland, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>We provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>This is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>This small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_half]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:13:37", "2015-02-11 02:13:37", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("152", "1", "2015-02-11 02:15:20", "2015-02-11 02:15:20", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Commercial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Industrial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading tag=\'h3\' padding=\'10\' heading=\'Institutional\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:15:20", "2015-02-11 02:15:20", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("153", "1", "2015-02-11 02:15:58", "2015-02-11 02:15:58", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading heading=\'Commercial\' tag=\'h3\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'25\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Industrial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Institutional\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:15:58", "2015-02-11 02:15:58", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("154", "1", "2015-02-11 02:16:31", "2015-02-11 02:16:31", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading heading=\'Commercial\' tag=\'h2\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'25\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Industrial\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h3\' padding=\'10\' heading=\'Institutional\' color=\'\' style=\'\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:16:31", "2015-02-11 02:16:31", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("155", "1", "2015-02-11 02:17:24", "2015-02-11 02:17:24", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5></h5>\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5></h5>\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Markham District Energy, Markham, Ontario</h5>\r\nMarkham District Energy, owned by the Town of Markham, owns and operates an EcoLogo certified community energy system that produces thermal energy and electricity. We are providing energy services for two new cogeneration plants - one at Bur Oak Energy Centre located at 3201 Bur Oak Avenue while the second system would located at the Birchmount Energy Centre at 7900 Birchmount Road, Markham Ontario. Construction is currently underway, with the work expected to be completed by the Fall of 2013.\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading heading=\'Industrial\' tag=\'h2\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'25\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading heading=\'Institutional\' tag=\'h2\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'25\' color=\'\' custom_font=\'\'][/av_heading]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:17:24", "2015-02-11 02:17:24", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("156", "1", "2015-02-11 02:26:06", "2015-02-11 02:26:06", "[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading heading=\'Institutional\' tag=\'h2\' style=\'blockquote modern-quote modern-centered\' size=\'\' subheading_active=\'\' subheading_size=\'15\' padding=\'25\' color=\'\' custom_font=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n[/av_textblock]\r\n\r\n[/av_one_full]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:26:06", "2015-02-11 02:26:06", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2015-02-11 02:28:01", "2015-02-11 02:28:01", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n\r\n<hr />\r\n\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n\r\n<hr />\r\n\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n\r\n<hr />\r\n\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n\r\n<hr />\r\n\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n\r\n<hr />\r\n\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n\r\n<hr />\r\n\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n\r\n<hr />\r\n\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n\r\n<hr />\r\n\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:28:01", "2015-02-11 02:28:01", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("158", "1", "2015-02-11 02:30:30", "2015-02-11 02:30:30", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n\r\n<hr />\r\n\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n\r\n<hr />\r\n\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n\r\n<hr />\r\n\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n\r\n<hr />\r\n\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n\r\n<hr />\r\n\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n\r\n<hr />\r\n\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n\r\n<hr />\r\n\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n\r\n<hr />\r\n\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n\r\n<hr />\r\n\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n\r\n<hr />\r\n\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n\r\n<hr />\r\n\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n\r\n<hr />\r\n\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n\r\n<hr />\r\n\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n\r\n<hr />\r\n\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n\r\n<hr />\r\n\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n\r\n<hr />\r\n\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n\r\n<hr />\r\n\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n\r\n<hr />\r\n\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:30:30", "2015-02-11 02:30:30", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2015-02-11 02:31:12", "2015-02-11 02:31:12", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n\r\n<hr />\r\n\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n\r\n<hr />\r\n\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n\r\n<hr />\r\n\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n\r\n<hr />\r\n\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n\r\n<hr />\r\n\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n\r\n<hr />\r\n\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n\r\n<hr />\r\n\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n\r\n<hr />\r\n\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n\r\n[/av_one_full][av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n\r\n<hr />\r\n\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n\r\n<hr />\r\n\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n\r\n<hr />\r\n\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n\r\n<hr />\r\n\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n\r\n<hr />\r\n\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n\r\n<hr />\r\n\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n\r\n<hr />\r\n\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n\r\n<hr />\r\n\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n\r\n<hr />\r\n\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n\r\n<hr />\r\n\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:31:12", "2015-02-11 02:31:12", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("160", "1", "2015-02-11 02:37:03", "2015-02-11 02:37:03", "[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nThe following brochures give an overview of some sector specific projects we have been working on:\r\n\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Commercial.pdf\">Commercial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Educational.pdf\">Educational</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-HealthCare.pdf\">Health Care</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-Industrial.pdf\">Industrial</a> | <a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/ARC-Brochure-LEED-Energy.pdf\">LEED and Energy Services</a>\r\n\r\nContinue reading on for descriptions of some projects currently in the design phase or recently completed.\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Commercial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\"><img class=\"  wp-image-101 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/gryphin.jpg\" alt=\"gryphin\" width=\"125\" height=\"83\" /></a>\r\n<h5>Gryphin Office Building, Burlington, Ontario</h5>\r\nThis is a new 12,000 sq.ft., 2 storey office building in Burlington.\r\n\r\n<hr />\r\n\r\n<h5>Wingbury Properties, Dundas, Ontario</h5>\r\nWingbury Properties Ltd. is developing a site in Dundas that will consist of a 40,000 sq.ft., 4 storey office building and a 2 storey Industrial complex. We are providing the plumbing, HVAC and fire protection design, as well as acting as LEED facilitators for the office portion of this project. Construction is currently underway and is expected to be completed in Summer, 2014.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Fallsview Casino Resort, Niagara Falls, Ontario</h5>\r\nProvided engineering services for several projects that include renovations to the existing Grand Buffet Kitchen, and 17 Noir Restaurant. Solar Hot water systems feasibility studies. Using RETScreen 4 software, a analysis was performed to determine feasibility of using solar hot water panels for both preheat of existing domestic hot water systems, and heating for an existing pool.\r\n\r\n<hr />\r\n\r\n<h5>Acres House Office Complex, Niagara Falls, Ontario</h5>\r\nProvided tenant review services for the building owner in order to ensure all base building standards were maintained. This included verifying capacity of existing mechanical and electrical systems.\r\n\r\n<hr />\r\n\r\n<h5>Limeridge Mall, Hamilton, Ontario</h5>\r\nProvide Mechanical and Electrical Engineering services for the new Kiddie Kobbler tenant fit-up\r\n\r\n<hr />\r\n\r\n<h5>Actlabs, Ancaster, Ontario</h5>\r\nActlabs is a worldwide company providing analytical testing and development services in the life sciences, minerals, environmental, forensics, and material testing markets. We provided preliminary LEED Facilitation services for a new 200,000sq.ft facility in Ancaster, Ontario.\r\n\r\n<hr />\r\n\r\n<h5>New Medical Building, Stoney Creek, Ontario</h5>\r\nThis is a new 2 story medical building in Stoney with a floor area of 12,500 sq.ft. It houses a Medical Clinic, a Physiotherapist Office, and space for a future tenant. Construction was recently completed.\r\n\r\n<hr />\r\n\r\n<h5>Alton Village, Burlington, Ontario</h5>\r\nThere are two new 2 story office buildings in Burlington on this site, with each having a floor area of 30,000 sq.ft. We provided mechanical services including HVAC, plumbing and fire protection design. The design phase is completed with construction expected to finish in Summer of 2013\r\n\r\n<hr />\r\n\r\n<h5>Sifto Salt Mine Facility, Goderich, Ontario</h5>\r\nThe Goderich area suffered heavy damage in the Summer of 2011 from tornadoes that passed through the area. The Sifto Salt Mine had extensive damage to the processing plant located here. We provided engineering services to help rebuild the plant in order to get the facility back on line. Using a design-build approach, we had staff on site in order to ensure the project moved ahead quickly, and was designed properly.\r\n\r\n<hr />\r\n\r\n<h5><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\"><img class=\"  wp-image-102 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/winery.png\" alt=\"winery\" width=\"125\" height=\"109\" /></a>GreenLane Estate Winery, Beamsville, Ontario</h5>\r\nThis small winery located in Beamsville is adding a 4,500sq.ft. process addition. We have provided a preliminary LEED review, and are currently acting as LEED facilitators, and providing energy modeling services. Keeping with the theme of the natural habitat that surrounds them, this project is aiming for LEED Silver using a variety of techniques to preserve and protect the environment.\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Industrial\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5 style=\"text-align: left;\"><a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\"><img class=\"  wp-image-100 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2015/01/niagara-housing.jpg\" alt=\"niagara housing\" width=\"125\" height=\"86\" /></a>Niagara Regional Housing, Welland, Ontario</h5>\r\nWe provided a design for new ventilation air systems for two buildings owned and operated by Niagara Regional Housing. The challenge on this project was limited space to locate new units and run new ductwork.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nWe are currently acting as the LEED Facilitator for a new IMS Office Building located in Thorold, Ontario. Although small in size, this will be the first LEED certified building for Walker Industries to help showcase their commitment to the environment and to sustainable design. Construction was completed in December of 2011.\r\n\r\n<hr />\r\n\r\n<h5>Walker Industries, Niagara Falls, Ontario</h5>\r\nUsing computerized modeling software, we provided energy modeling services to determine potential Energy Savings Credits under LEED for a new 1,600sq.ft. office building. The Owner incorporated changes identified by the modeling that would reduce long term operating costs.\r\n\r\n<hr />\r\n\r\n<h5>St. Lawrence Seaway Townline Tunnel, Welland, Ontario</h5>\r\nWe completed a feasibility study to evaluate the existing fire protection situation and propose practical recommendations for improvements for the Townline Tunnel under the Welland Canal in Welland, Ontario, Canada.\r\n\r\n<hr />\r\n\r\n<h5>CDSBN - St. Patrick\'s, Niagara Falls, Ontario</h5>\r\nBoiler venting modifications.\r\n\r\n<hr />\r\n\r\n<h5>Pearson Airport. Toronto, Ontario</h5>\r\nGTAA Fueling System\r\n\r\n<hr />\r\n\r\n<h5>Project Management - JNE Consulting Engineering</h5>\r\nSubconsulting on P&amp;G HABC Asia Pacific GSS Projects\r\n\r\nSubconsulting on Pompano Beach on 9 MW Combined Cycle Conversion Design Build Project\r\n\r\nSubconsulting for ISO 9000 Certification Planning and Implementation\r\n\r\nSubconsulting on Stelco By-Products Misa Project\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_heading tag=\'h2\' padding=\'25\' heading=\'Institutional\' color=\'\' style=\'blockquote modern-quote modern-centered\' custom_font=\'\' size=\'\' subheading_active=\'\' subheading_size=\'15\' custom_class=\'\'][/av_heading]\r\n\r\n[av_one_full first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Pathstone Mental Health, Thorold, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\"><img class=\"  wp-image-94 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/pathstone.jpg\" alt=\"pathstone\" width=\"150\" height=\"112\" /></a>Pathstone Mental Health is a non-profit charitable organization operating under the Child and Family Services Act, governed by a community-based Board of Directors. Pathstone is an accredited children’s mental health agency with Children’s Mental Health Ontario. Pathstone Mental Health has decided to develop a property to suit its unique needs. To accomplish this, Pathstone Foundation is constructing a new 50,000 sq.ft. treatment facility. Currently in the design phase, we are providing Mechanical Engineering services that include HVAC, plumbing and fire protection design.\r\n\r\n<hr />\r\n\r\n<h5>District School Board of Niagara, Niagara Region, Ontario</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\"><img class=\"  wp-image-95 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/district-school-bd-niagara.jpg\" alt=\"district school bd niagara\" width=\"150\" height=\"120\" /></a>We are involved in several school renovation projects that include Port Weller School in St. Catharines, Garrison Road School in Fort Erie, and Fitch Street, Ross and Princess Elizabeth Elementary schools in Welland. Construction is currently underway and is expected to be completed in Summer, 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara College, St. Catharines, Ontario</h5>\r\nNiagara College recently received funding from the Government of Canada’s Colleges Industry Innovation Fund for its Niagara Food, Culinary and Beverage Innovation Centre. We provided mechanical services or renovations to add a Food Microbiology Lab, Food Chemistry Lab, Food Quality Lab, and a Shelf Life Analysis Lab. Work was completed in the Spring of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Brock University, St .Catharines, Ontario</h5>\r\nOur current project includes providing Consulting Services for the renovations of the Brock Learning Commons\r\n\r\n<hr />\r\n\r\n<h5>McMaster University Medical Centre, Hamilton, Ontario</h5>\r\nCurrently we are working on several projects that include renovations of the existing gift shop/pharmacy and providing consulting services for the design of the renovations required in the 3B Unit (North-West) at the University Medical Centre (MUMC) located on level 3.\r\n\r\n<hr />\r\n\r\n<h5>McMaster University, Hamilton, Ontario</h5>\r\nWe provided Mechanical services for a new barrier free washroom upgrade at the Moulton Hall Residence on campus, and renovations for the McMaster University Commons Building Front Desk\r\n\r\n<hr />\r\n\r\n<h5>Deer Park Villa Long Term Care Facility, Grimsby, Ontario</h5>\r\nWe are acting as the LEED Facilitator and providing energy modeling services for a new 44,000 sq.ft addition to the existing facility. The target for this project is LEED Silver. The building is currently managed by the Niagara Region and shows their commitment to be a leader in energy efficiency and sustainability. Phase One is complete, with Phase Two expected to be finished in summer of 2013.\r\n\r\n<hr />\r\n\r\n<h5>Niagara Regional Police Services, Fort Erie, Ontario</h5>\r\nWe performed a preliminary energy model for LEED using computerized modeling software to determine potential points available under the Energy and Atmosphere category. We also provided energy modeling in order to complete an HPNC application, enabling the building owner to qualify for approximately $20,000 in government incentives. Changes were made in the design based on the energy model in order to reduce long term operating costs for the Niagara Region, and provide an environmentally sustainable design. This is a 14,000sq.ft. facility and includes shared space with Emergency Medical Services complete with a 4 vehicle Ambulance Bay.\r\n\r\n<hr />\r\n\r\n<h5>Ridley College, St. Catharines, Ontario</h5>\r\nChapel Heating Retrofit\r\n\r\nAquatic Centre HVAC Renovation\r\n\r\nGymnasium Weight Training Area Retrofit\r\n\r\nScience Room area Retrofit\r\n\r\n<hr />\r\n\r\n<h5>Linhaven Home for the Aged, St. Catharines, Ontario</h5>\r\nBoiler Burner Retrofit\r\n\r\nDomestic Hot Water Plant Retrofit\r\n\r\n<hr />\r\n\r\n[/av_textblock]\r\n[/av_one_full]\r\n\r\n[av_hr class=\'default\' height=\'50\' shadow=\'no-shadow\' position=\'center\' custom_border=\'av-border-thin\' custom_width=\'50px\' custom_border_color=\'\' custom_margin_top=\'30px\' custom_margin_bottom=\'30px\' icon_select=\'yes\' custom_icon_color=\'\' icon=\'ue808\']\r\n\r\n[av_iconlist position=\'left\' font_color=\'\' custom_title=\'\' custom_content=\'\' color=\'\' custom_bg=\'\' custom_font=\'\' custom_border=\'\']\r\n[av_iconlist_item title=\'List Title 1\' icon=\'43\' content=\'Enter content here\']\r\n[av_iconlist_item title=\'List Title 2\' icon=\'25\' content=\'Enter content here\']\r\n[av_iconlist_item title=\'List Title 3\' icon=\'64\' content=\'Enter content here\']\r\n[/av_iconlist]", "Portfolio", "", "inherit", "closed", "open", "", "10-revision-v1", "", "", "2015-02-11 02:37:03", "2015-02-11 02:37:03", "", "10", "http://sightseer.ca/arcengineering/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("161", "2", "2015-02-17 16:37:39", "2015-02-17 16:37:39", "[av_one_half first]\r\n\r\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\r\n[av_slide id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'62\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\r\n[av_slide id=\'140\'][/av_slide]\r\n[av_slide id=\'141\'][/av_slide]\r\n[av_slide id=\'137\'][/av_slide]\r\n[av_slide id=\'134\'][/av_slide]\r\n[/av_slideshow]\r\n\r\n[/av_one_half][av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\r\n\r\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\"  wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"150\" height=\"150\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\r\n\r\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\r\n\r\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\r\n\r\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\r\n\r\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\r\n\r\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\r\n\r\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\r\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\"  wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"150\" height=\"150\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\r\n\r\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\r\n\r\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\r\n\r\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\r\n\r\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\r\n\r\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\r\n[/av_textblock]\r\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-revision-v1", "", "", "2015-02-17 16:37:39", "2015-02-17 16:37:39", "", "5", "http://sightseer.ca/arcengineering/5-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("162", "2", "2015-02-17 16:49:52", "2015-02-17 16:49:52", "", "burloak stack cropped", "", "inherit", "closed", "open", "", "burloak-stack-cropped", "", "", "2015-02-17 16:49:52", "2015-02-17 16:49:52", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/02/burloak-stack-cropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("163", "2", "2015-02-17 16:59:54", "2015-02-17 16:59:54", "", "cogencropped", "", "inherit", "closed", "open", "", "cogencropped", "", "", "2015-02-17 16:59:54", "2015-02-17 16:59:54", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/cogencropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("164", "2", "2015-02-17 17:00:56", "2015-02-17 17:00:56", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'134\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'135\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'140\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'163\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-02-17 17:00:56", "2015-02-17 17:00:56", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("166", "2", "2015-02-17 17:07:55", "2015-02-17 17:07:55", "", "cogencropped", "", "inherit", "closed", "open", "", "cogencropped-2", "", "", "2015-02-17 17:07:55", "2015-02-17 17:07:55", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/cogencropped1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("167", "2", "2015-02-17 17:08:07", "2015-02-17 17:08:07", "", "controlsystemscropped", "", "inherit", "closed", "open", "", "controlsystemscropped", "", "", "2015-02-17 17:08:07", "2015-02-17 17:08:07", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/controlsystemscropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("168", "2", "2015-02-17 17:08:20", "2015-02-17 17:08:20", "", "labcropped", "", "inherit", "closed", "open", "", "labcropped", "", "", "2015-02-17 17:08:20", "2015-02-17 17:08:20", "", "2", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/labcropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("169", "2", "2015-02-17 17:08:48", "2015-02-17 17:08:48", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'166\'][/av_slide_full]\r\n[av_slide_full id=\'167\'][/av_slide_full]\r\n[av_slide_full id=\'168\'][/av_slide_full]\r\n[av_slide_full id=\'162\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design.\r\n\r\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\r\n\r\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\r\n\r\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\r\n[/av_textblock]\r\n\r\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "inherit", "closed", "open", "", "2-revision-v1", "", "", "2015-02-17 17:08:48", "2015-02-17 17:08:48", "", "2", "http://sightseer.ca/arcengineering/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("170", "2", "2015-02-17 17:14:24", "2015-02-17 17:14:24", "", "cranecopped", "", "inherit", "closed", "open", "", "cranecopped", "", "", "2015-02-17 17:14:24", "2015-02-17 17:14:24", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/cranecopped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("171", "2", "2015-02-17 17:14:35", "2015-02-17 17:14:35", "", "building1cropped", "", "inherit", "closed", "open", "", "building1cropped", "", "", "2015-02-17 17:14:35", "2015-02-17 17:14:35", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/building1cropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("172", "2", "2015-02-17 17:15:19", "2015-02-17 17:15:19", "", "building1cropped", "", "inherit", "closed", "open", "", "building1cropped-2", "", "", "2015-02-17 17:15:19", "2015-02-17 17:15:19", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/building1cropped1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("173", "2", "2015-02-17 17:20:33", "2015-02-17 17:20:33", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\n[av_slide_full id=\'171\'][/av_slide_full]\n[av_slide_full id=\'170\'][/av_slide_full]\n[/av_slideshow_full]\n\n[av_one_half first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h3>Services</h3>\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\n\nWe provide services for new and renovated projects including:\n<ul>\n	<li>Commercial Projects</li>\n	<li>Office Buildings</li>\n	<li>Building conversions</li>\n	<li>Institutional projects</li>\n	<li>Shopping centres</li>\n	<li>Retrofits</li>\n	<li>HVAC, Plumbing, and Fire Protection</li>\n	<li>LEED Services</li>\n	<li>Energy Modeling</li>\n</ul>\n<h5>Report and Studies.</h5>\n<ul>\n	<li>Building Condition Reports</li>\n	<li>Feasibility Studies</li>\n	<li>Energy Analysis</li>\n</ul>\n[/av_textblock]\n[/av_one_half]\n\n[av_one_half]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h3>Partnerships</h3>\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\n\nElectrical\n\nArchitectural\n\nStructural\n\nCivil\n\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\n[/av_textblock]\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-autosave-v1", "", "", "2015-02-17 17:20:33", "2015-02-17 17:20:33", "", "8", "http://sightseer.ca/arcengineering/8-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("174", "2", "2015-02-17 17:53:19", "2015-02-17 17:53:19", "", "engineeingmeetingcropped", "", "inherit", "closed", "open", "", "engineeingmeetingcropped", "", "", "2015-02-17 17:53:19", "2015-02-17 17:53:19", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/engineeingmeetingcropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("175", "2", "2015-02-17 17:53:25", "2015-02-17 17:53:25", "", "drawingandmodelcropped", "", "inherit", "closed", "open", "", "drawingandmodelcropped", "", "", "2015-02-17 17:53:25", "2015-02-17 17:53:25", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/drawingandmodelcropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("176", "2", "2015-02-17 17:53:31", "2015-02-17 17:53:31", "", "engdrawingcropped", "", "inherit", "closed", "open", "", "engdrawingcropped", "", "", "2015-02-17 17:53:31", "2015-02-17 17:53:31", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/engdrawingcropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("177", "2", "2015-02-17 17:53:46", "2015-02-17 17:53:46", "", "wordchartcropped", "", "inherit", "closed", "open", "", "wordchartcropped", "", "", "2015-02-17 17:53:46", "2015-02-17 17:53:46", "", "8", "http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/wordchartcropped.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("178", "2", "2015-02-17 17:54:11", "2015-02-17 17:54:11", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'174\'][/av_slide_full]\r\n[av_slide_full id=\'175\'][/av_slide_full]\r\n[av_slide_full id=\'176\'][/av_slide_full]\r\n[av_slide_full id=\'177\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Services</h3>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Partnerships</h3>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2015-02-17 17:54:11", "2015-02-17 17:54:11", "", "8", "http://sightseer.ca/arcengineering/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("179", "2", "2015-02-17 17:57:42", "2015-02-17 17:57:42", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\r\n[av_slide_full id=\'177\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'176\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'175\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[av_slide_full id=\'174\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_format=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' custom_title_size=\'\' custom_content_size=\'\' caption_pos=\'caption_bottom\' link_apply=\'\' link=\'\' link_target=\'\' button_label=\'Click me\' button_color=\'light\' link1=\'\' link_target1=\'\' button_label2=\'Click me\' button_color2=\'light\' link2=\'\' link_target2=\'\' font_color=\'\' custom_title=\'\' custom_content=\'\'][/av_slide_full]\r\n[/av_slideshow_full]\r\n\r\n[av_one_half first]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Services</h3>\r\nWe work with our clients through every step of the engineering process to ensure a cost effective and appropriate design. Our services extend to the commercial, institutional, retail, and industrial market sectors.\r\n\r\nWe provide services for new and renovated projects including:\r\n<ul>\r\n	<li>Commercial Projects</li>\r\n	<li>Office Buildings</li>\r\n	<li>Building conversions</li>\r\n	<li>Institutional projects</li>\r\n	<li>Shopping centres</li>\r\n	<li>Retrofits</li>\r\n	<li>HVAC, Plumbing, and Fire Protection</li>\r\n	<li>LEED Services</li>\r\n	<li>Energy Modeling</li>\r\n</ul>\r\n<h5>Report and Studies.</h5>\r\n<ul>\r\n	<li>Building Condition Reports</li>\r\n	<li>Feasibility Studies</li>\r\n	<li>Energy Analysis</li>\r\n</ul>\r\n[/av_textblock]\r\n[/av_one_half]\r\n\r\n[av_one_half]\r\n[av_textblock size=\'\' font_color=\'\' color=\'\']\r\n<h3>Partnerships</h3>\r\nWe have formed partnerships with several local firms in order to offer a full range of services beyond Mechanical and LEED/Energy Design. Where a project requires other disciplines, we can team up with local firms with proven track records to provide a complete team approach that can include the following:\r\n\r\nElectrical\r\n\r\nArchitectural\r\n\r\nStructural\r\n\r\nCivil\r\n\r\nThis allows us to scale our services to meet our clients needs and provide the most affordable design solution.\r\n[/av_textblock]\r\n[/av_one_half]", "Services", "", "inherit", "closed", "open", "", "8-revision-v1", "", "", "2015-02-17 17:57:42", "2015-02-17 17:57:42", "", "8", "http://sightseer.ca/arcengineering/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("180", "1", "2015-04-24 01:33:10", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "closed", "open", "", "", "", "", "2015-04-24 01:33:10", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?p=180", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("181", "1", "2015-04-24 01:41:47", "2015-04-24 01:41:47", "", "ARC_Logo", "", "inherit", "closed", "open", "", "arc_logo", "", "", "2015-04-24 01:41:47", "2015-04-24 01:41:47", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/04/ARC_Logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("182", "1", "2015-04-24 01:42:38", "2015-04-24 01:42:38", "", "ARC_Logo", "", "inherit", "closed", "open", "", "arc_logo-2", "", "", "2015-04-24 01:42:38", "2015-04-24 01:42:38", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/04/ARC_Logo1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("183", "2", "2015-04-24 12:48:24", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "closed", "open", "", "", "", "", "2015-04-24 12:48:24", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?p=183", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("184", "3", "2015-04-24 12:55:45", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "closed", "open", "", "", "", "", "2015-04-24 12:55:45", "0000-00-00 00:00:00", "", "0", "http://sightseer.ca/arcengineering/?p=184", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("185", "3", "2015-04-24 12:58:19", "2015-04-24 12:58:19", "[av_one_half first]\n[av_slideshow size=\'medium\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'\']\n[av_slide id=\'63\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\n[av_slide id=\'62\' slide_type=\'\' video=\'http://\' mobile_image=\'\' video_ratio=\'16:9\' video_controls=\'\' video_mute=\'\' video_loop=\'\' video_autoplay=\'\' title=\'\' link_apply=\'\' link=\'\' link_target=\'\'][/av_slide]\n[av_slide id=\'140\'][/av_slide]\n[av_slide id=\'141\'][/av_slide]\n[av_slide id=\'137\'][/av_slide]\n[av_slide id=\'134\'][/av_slide]\n[/av_slideshow]\n[/av_one_half]\n\n[av_one_half]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nWe have completed many projects ranging from new commercial construction, healthcare, industrial and commercial renovation projects, LEED Facilitation and Rebate Incentive applications. From conceptual design, to final commissioning, we are involved every step of the way.\n\nWe look forward to the future, and working closely with our partners in order to provide quality service, sustainable design, and affordable solutions.\n[/av_textblock]\n\n[/av_one_half][av_one_half first]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Art Rebek, P.Eng, LEED AP. - President</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\"><img class=\"  wp-image-89 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/art.jpg\" alt=\"art\" width=\"150\" height=\"150\" /></a>Following the completion of a steamfitting apprenticeship and graduation from mechanical engineering, Art continued his construction engineering experience with Comstock International in 1982.\n\nIn 1985 he accepted a position with The Mitchell Partnership where he gained design experience in a number of office buildings, educational facilities, retail, and sports recreational facilities.\n\nArt left in 1989 to head up the mechanical engineering department in a multi-disciplinary firm. The work included HVAC, and piping systems in schools, hospitals, wineries, automotive manufacturing plants, pulp and paper, and metal refining facilities\n\nIn 1995 he founded his own company, “ARC Engineering Inc.”, where he worked on commercial HVAC, industrial projects in the steel industry, health and beauty care manufacturing sector facilities, and energy systems including cogeneration.\n\nArt joined the Columbus Team of Jungbunzlauer in 2000 as Engineering Manager for the construction of a $150 M citric acid manufacturing plant on a greenfield site in Port Colborne Ontario.\n\nFollowing start-up and initial operation of the facility Art returned to The Mitchell Partnership in their new branch office in St. Catharines, Ontario. Art has since worked on a number of retail, office, institutional, and entertainment facilities.\n\nIn September of 2010, Art along with Brad Robinson, reactivated ARC Engineering Inc. to continue to offer Engineering Services in the Niagara Region and surrounding areas.\n[/av_textblock]\n[/av_one_half]\n\n[av_one_half]\n[av_textblock size=\'\' font_color=\'\' color=\'\']\n<h5>Brad Robinson, P.Eng, LEED AP, BD+C - Project Manager</h5>\n<a href=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\"><img class=\"  wp-image-90 alignleft\" src=\"http://sightseer.ca/arcengineering/wp-content/uploads/2014/11/brad.jpg\" alt=\"brad\" width=\"150\" height=\"150\" /></a>Brad began his career at J.David Pounder Ltd., a multidisciplinary firm that included a range or services such as Architectural Design, Site Servicing, mechanical, electrical and structural design. Here he would be involved in a project from the initial site plan application to the final inspection, giving him a well rounded knowledge of several areas of project design.\n\nBrad was also involved in Building Inspection when he took a position of Building Inspector at the City of Niagara Falls. This included buildings under Part 3 and Part 9 of the OBC.\n\nBrad\'s career briefly followed a different path when he took a a position at Niagara Piston. Here he was involved in the design of 3D drawings in the relatively new area of Phenolic piston production and tooling. He continued this development work at Mold Spec, working on the design of the molds used in the phenolic piston process.\n\nBrad\'s career continued in the building services design when he took a position at NRB Inc., a modular building company, where he was in charge of the CAD Department, as well as design of production drawings for buildings both in Canada and the United States.\n\nHis next move was to TMP Niagara, where he worked with Art Rebek as a Mechanical Design Engineer for 5 years. This local branch of the Mitchell Partnership closed in 2008. Brad continued his career in the Niagara Region as a Mechanical Engineer at Quartek Group Inc. where he was involved in design of several local projects, including the new Niagara District Airport Terminal.\n\nIn September of 2010, Brad joined back up with Art Rebek to re-open ARC Engineering Inc.\n[/av_textblock]\n[/av_one_half]", "About Us", "", "inherit", "closed", "open", "", "5-autosave-v1", "", "", "2015-04-24 12:58:19", "2015-04-24 12:58:19", "", "5", "http://sightseer.ca/arcengineering/5-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("186", "3", "2015-04-24 18:24:41", "2015-04-24 18:24:41", "", "logo5 long (1)", "", "inherit", "closed", "open", "", "logo5-long-1", "", "", "2015-04-24 18:24:41", "2015-04-24 18:24:41", "", "0", "http://sightseer.ca/arcengineering/wp-content/uploads/2015/04/logo5-long-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("187", "3", "2015-04-24 18:28:28", "2015-04-24 18:28:28", "[av_slideshow_full size=\'featured\' stretch=\'\' animation=\'slide\' autoplay=\'true\' interval=\'5\' control_layout=\'av-control-default\' src=\'\' attachment=\'\' attachment_size=\'\' position=\'top left\' repeat=\'no-repeat\' attach=\'scroll\']\n[av_slide_full id=\'166\'][/av_slide_full]\n[av_slide_full id=\'167\'][/av_slide_full]\n[av_slide_full id=\'168\'][/av_slide_full]\n[av_slide_full id=\'162\'][/av_slide_full]\n[/av_slideshow_full]\n\n[av_textblock size=\'\' font_color=\'\' color=\'\']\nARC Engineering is a “full service mechanical engineering company.”  We help our clients implement  new designs or improve on an existing design. This is our mission\n\nOur Goal is to understand  our clients objectives so we can recommend and implement the most effective solution.\n\nWe do this by providing innovative solutions through engineering excellence in Building Services Design – HVAC, plumbing and fire protection systems .  As a result, our clients benefit from premium design and cost effective implementations.\n\n<span class=\"bold\"><a href=\"http://\">Click here to download one of our brochures</a></span>\n\n<span class=\"bold\"><a href=\"http://\">Click here for our latest job postings</a></span>\n[/av_textblock]\n\n[av_portfolio columns=\'4\' one_column_template=\'special\' items=\'4\' contents=\'excerpt\' preview_mode=\'custom\' image_size=\'medium\' linking=\'\' sort=\'yes\' paginate=\'yes\']", "Home", "", "inherit", "closed", "open", "", "2-autosave-v1", "", "", "2015-04-24 18:28:28", "2015-04-24 18:28:28", "", "2", "http://sightseer.ca/arcengineering/2-autosave-v1/", "0", "revision", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("26", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("27", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("28", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("29", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("30", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("31", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("70", "1", "0");
INSERT INTO `wp_term_relationships` VALUES("130", "4", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "3");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "nav_menu", "", "0", "6");
INSERT INTO `wp_term_taxonomy` VALUES("3", "3", "portfolio_entries", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "portfolio_entries", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("5", "5", "portfolio_entries", "", "0", "0");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO `wp_terms` VALUES("2", "Main Menu", "main-menu", "0");
INSERT INTO `wp_terms` VALUES("3", "Industrial", "industrial", "0");
INSERT INTO `wp_terms` VALUES("4", "Commercial", "commercial", "0");
INSERT INTO `wp_terms` VALUES("5", "Institutional", "institutional", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "admin");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("9", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("10", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("11", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("12", "1", "dismissed_wp_pointers", "wp350_media,wp360_revisions,wp360_locks,wp390_widgets,builder-button-pointer,wp410_dfw");
INSERT INTO `wp_usermeta` VALUES("13", "1", "show_welcome_panel", "1");
INSERT INTO `wp_usermeta` VALUES("15", "1", "wp_dashboard_quick_press_last_post_id", "180");
INSERT INTO `wp_usermeta` VALUES("16", "1", "wp_user-settings", "editor=tinymce&hidetb=1&wplink=1&libraryContent=browse");
INSERT INTO `wp_usermeta` VALUES("17", "1", "wp_user-settings-time", "1416880609");
INSERT INTO `wp_usermeta` VALUES("18", "1", "managenav-menuscolumnshidden", "a:4:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}");
INSERT INTO `wp_usermeta` VALUES("19", "1", "metaboxhidden_nav-menus", "a:3:{i:0;s:8:\"add-post\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";}");
INSERT INTO `wp_usermeta` VALUES("20", "1", "nav_menu_recently_edited", "2");
INSERT INTO `wp_usermeta` VALUES("21", "1", "layerslider_help_wp_pointer", "1");
INSERT INTO `wp_usermeta` VALUES("22", "1", "closedpostboxes_post", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("23", "1", "metaboxhidden_post", "a:6:{i:0;s:11:\"postexcerpt\";i:1;s:13:\"trackbacksdiv\";i:2;s:10:\"postcustom\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}");
INSERT INTO `wp_usermeta` VALUES("24", "1", "default_password_nag", "");
INSERT INTO `wp_usermeta` VALUES("25", "2", "nickname", "dwindsor");
INSERT INTO `wp_usermeta` VALUES("26", "2", "first_name", "Doug");
INSERT INTO `wp_usermeta` VALUES("27", "2", "last_name", "Windsor");
INSERT INTO `wp_usermeta` VALUES("28", "2", "description", "");
INSERT INTO `wp_usermeta` VALUES("29", "2", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("30", "2", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("31", "2", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("32", "2", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("33", "2", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("34", "2", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("35", "2", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("36", "2", "dismissed_wp_pointers", "wp360_locks,wp390_widgets,builder-button-pointer,wp410_dfw");
INSERT INTO `wp_usermeta` VALUES("37", "2", "session_tokens", "a:1:{s:64:\"d64466d8c8d3173257f677de1d13568530c36bdfe2c6f6fff10a0d80e29fea13\";a:4:{s:10:\"expiration\";i:1430052503;s:2:\"ip\";s:13:\"24.141.201.49\";s:2:\"ua\";s:108:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.90 Safari/537.36\";s:5:\"login\";i:1429879703;}}");
INSERT INTO `wp_usermeta` VALUES("38", "2", "wp_dashboard_quick_press_last_post_id", "183");
INSERT INTO `wp_usermeta` VALUES("39", "2", "layerslider_help_wp_pointer", "1");
INSERT INTO `wp_usermeta` VALUES("40", "2", "wp_user-settings", "libraryContent=upload");
INSERT INTO `wp_usermeta` VALUES("41", "2", "wp_user-settings-time", "1424195647");
INSERT INTO `wp_usermeta` VALUES("42", "1", "meta-box-order_page", "a:3:{s:4:\"side\";s:43:\"submitdiv,pageparentdiv,layout,postimagediv\";s:6:\"normal\";s:95:\"avia_builder,revisionsdiv,postexcerpt,postcustom,commentstatusdiv,commentsdiv,slugdiv,authordiv\";s:8:\"advanced\";s:0:\"\";}");
INSERT INTO `wp_usermeta` VALUES("43", "1", "screen_layout_page", "2");
INSERT INTO `wp_usermeta` VALUES("44", "1", "session_tokens", "a:2:{s:64:\"8f8681ea54d86c3ab0a41db6d5227671fc183f07875989a4f20e7963830e7d2c\";a:4:{s:10:\"expiration\";i:1430011989;s:2:\"ip\";s:13:\"99.247.240.34\";s:2:\"ua\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:37.0) Gecko/20100101 Firefox/37.0\";s:5:\"login\";i:1429839189;}s:64:\"3c297d1941f7804f178311506a65a2deae4df12b0f442c0047154520acfc177d\";a:4:{s:10:\"expiration\";i:1430147805;s:2:\"ip\";s:13:\"99.247.240.34\";s:2:\"ua\";s:82:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:37.0) Gecko/20100101 Firefox/37.0\";s:5:\"login\";i:1429975005;}}");
INSERT INTO `wp_usermeta` VALUES("45", "3", "nickname", "arc admin");
INSERT INTO `wp_usermeta` VALUES("46", "3", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("47", "3", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("48", "3", "description", "");
INSERT INTO `wp_usermeta` VALUES("49", "3", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("50", "3", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("51", "3", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("52", "3", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("53", "3", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("54", "3", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("55", "3", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("56", "3", "dismissed_wp_pointers", "wp360_locks,wp390_widgets,builder-button-pointer");
INSERT INTO `wp_usermeta` VALUES("57", "3", "session_tokens", "a:2:{s:64:\"0eb3075daf22e48d83daac34efeacce964595d83ff16d62f7ee65b8432c5dfbe\";a:4:{s:10:\"expiration\";i:1430052945;s:2:\"ip\";s:13:\"24.141.201.49\";s:2:\"ua\";s:108:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.90 Safari/537.36\";s:5:\"login\";i:1429880145;}s:64:\"3109280670e93147ef28045d3d30870908ef91a8fe8276ca852a62bb8ea5ede9\";a:4:{s:10:\"expiration\";i:1430072191;s:2:\"ip\";s:14:\"184.148.46.158\";s:2:\"ua\";s:108:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.90 Safari/537.36\";s:5:\"login\";i:1429899391;}}");
INSERT INTO `wp_usermeta` VALUES("58", "3", "wp_dashboard_quick_press_last_post_id", "184");
INSERT INTO `wp_usermeta` VALUES("59", "3", "wp_user-settings", "libraryContent=browse");
INSERT INTO `wp_usermeta` VALUES("60", "3", "wp_user-settings-time", "1429901331");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "admin", "$P$BZRuCutT1amcVFy9KYLaIbSp84wPNT1", "admin", "kbanse@bansecreative.com", "", "2014-11-25 01:25:20", "", "0", "admin");
INSERT INTO `wp_users` VALUES("2", "dwindsor", "$P$Bd2nyKZQX9g5Vdfq/EJ20yzQCYJpLb1", "dwindsor", "doug@strategyonedigital.com", "", "2014-12-22 18:59:14", "", "0", "Doug Windsor");
INSERT INTO `wp_users` VALUES("3", "arc admin", "$P$BV/itlAnEN1YAceBXFooJC2G/aq/oh/", "arc-admin", "arebek@arcengineering.ca", "", "2015-04-24 12:55:26", "", "0", "arc admin");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2015-04-25 15:18:42*/
/* DUPLICATOR_MYSQLDUMP_EOF */
